/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal.coordinator;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.internal.MemberInfo;
import net.kuujo.copycat.cluster.internal.coordinator.MemberCoordinator;
import net.kuujo.copycat.util.internal.Assert;

abstract class AbstractMemberCoordinator
implements MemberCoordinator {
    private final MemberInfo info;
    private volatile boolean open;

    protected AbstractMemberCoordinator(MemberInfo info) {
        this.info = Assert.isNotNull(info, "info");
    }

    @Override
    public String uri() {
        return this.info.uri();
    }

    @Override
    public Member.Type type() {
        return this.info.type();
    }

    @Override
    public Member.Status state() {
        return this.info.state();
    }

    @Override
    public CompletableFuture<MemberCoordinator> open() {
        this.open = true;
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public CompletableFuture<Void> close() {
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }
}

