/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal.coordinator;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValueFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.resource.Resource;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.util.serializer.KryoSerializer;
import net.kuujo.copycat.util.serializer.Serializer;

public class CoordinatedResourceConfig
extends AbstractConfigurable {
    private static final String RESOURCE_CONFIG = "config";
    private static final String RESOURCE_TYPE = "type";
    private static final String RESOURCE_ELECTION_TIMEOUT = "election.timeout";
    private static final String RESOURCE_HEARTBEAT_INTERVAL = "heartbeat.interval";
    private static final String RESOURCE_REPLICAS = "replicas";
    private static final String RESOURCE_LOG = "log";
    private static final String RESOURCE_SERIALIZER = "serializer";
    private Serializer serializer;
    private Serializer defaultSerializer = new KryoSerializer();
    private Executor defaultExecutor;
    private Executor executor;
    private Class<? extends Resource> resourceTypeClass;

    public CoordinatedResourceConfig() {
    }

    public CoordinatedResourceConfig(Map<String, Object> config) {
        super(config, new String[0]);
    }

    protected CoordinatedResourceConfig(CoordinatedResourceConfig config) {
        super(config);
    }

    @Override
    public CoordinatedResourceConfig copy() {
        return new CoordinatedResourceConfig(this);
    }

    public <T extends ResourceConfig<T>> void setResourceConfig(T config) {
        this.config = this.config.withValue(RESOURCE_CONFIG, ConfigValueFactory.fromMap(Assert.isNotNull(config, RESOURCE_CONFIG).toMap()));
    }

    public <T extends ResourceConfig<T>> T getResourceConfig() {
        return (T)((ResourceConfig)Configurable.load(this.config.getObject(RESOURCE_CONFIG).unwrapped()));
    }

    public <T extends ResourceConfig<T>> CoordinatedResourceConfig withResourceConfig(T config) {
        this.setResourceConfig(config);
        return this;
    }

    public void setResourceType(Class<? extends Resource> type) {
        this.resourceTypeClass = Assert.isNotNull(type, RESOURCE_TYPE);
    }

    public Class<? extends Resource> getResourceType() {
        try {
            return this.resourceTypeClass != null ? this.resourceTypeClass : Class.forName(this.config.getString(RESOURCE_TYPE));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to load resource class", new Object[]{e});
        }
    }

    public CoordinatedResourceConfig withResourceType(Class<? extends Resource> type) {
        this.setResourceType(type);
        return this;
    }

    public void setElectionTimeout(long electionTimeout) {
        this.config = this.config.withValue(RESOURCE_ELECTION_TIMEOUT, ConfigValueFactory.fromAnyRef(Assert.arg(electionTimeout, electionTimeout > 0L, "election timeout must be positive", new Object[0])));
    }

    public void setElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(unit.toMillis(electionTimeout));
    }

    public long getElectionTimeout() {
        return this.config.getLong(RESOURCE_ELECTION_TIMEOUT);
    }

    public CoordinatedResourceConfig withElectionTimeout(long electionTimeout) {
        this.setElectionTimeout(electionTimeout);
        return this;
    }

    public CoordinatedResourceConfig withElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(electionTimeout, unit);
        return this;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.config = this.config.withValue(RESOURCE_HEARTBEAT_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(heartbeatInterval, heartbeatInterval > 0L, "heartbeat interval must be positive", new Object[0])));
    }

    public void setHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(unit.toMillis(heartbeatInterval));
    }

    public long getHeartbeatInterval() {
        return this.config.getLong(RESOURCE_HEARTBEAT_INTERVAL);
    }

    public CoordinatedResourceConfig withHeartbeatInterval(long heartbeatInterval) {
        this.setHeartbeatInterval(heartbeatInterval);
        return this;
    }

    public CoordinatedResourceConfig withHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(heartbeatInterval, unit);
        return this;
    }

    public void setReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
    }

    public void setReplicas(Collection<String> replicas) {
        this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(new HashSet<String>(Assert.isNotNull(replicas, RESOURCE_REPLICAS))));
    }

    public Set<String> getReplicas() {
        return new HashSet<String>(this.config.hasPath(RESOURCE_REPLICAS) ? this.config.getList(RESOURCE_REPLICAS).unwrapped() : new ArrayList(0));
    }

    public CoordinatedResourceConfig withReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
        return this;
    }

    public CoordinatedResourceConfig withReplicas(Collection<String> replicas) {
        this.setReplicas(replicas);
        return this;
    }

    public CoordinatedResourceConfig addReplica(String replica) {
        if (!this.config.hasPath(RESOURCE_REPLICAS)) {
            this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(new ArrayList(1)));
        }
        ConfigList replicas = this.config.getList(RESOURCE_REPLICAS);
        replicas.add(ConfigValueFactory.fromAnyRef(Assert.isNotNull(replica, "replica")));
        return this;
    }

    public CoordinatedResourceConfig removeReplica(String replica) {
        ConfigList replicas = this.config.getList(RESOURCE_REPLICAS);
        replicas.remove(ConfigValueFactory.fromAnyRef(Assert.isNotNull(replica, "replica")));
        return this;
    }

    public CoordinatedResourceConfig clearReplicas() {
        this.config.withoutPath(RESOURCE_REPLICAS);
        return this;
    }

    public void setLog(Log log) {
        this.config = this.config.withValue(RESOURCE_LOG, ConfigValueFactory.fromMap(log.toMap()));
    }

    public Log getLog() {
        return (Log)Configurable.load(this.config.getObject(RESOURCE_LOG).unwrapped());
    }

    public CoordinatedResourceConfig withLog(Log log) {
        this.setLog(log);
        return this;
    }

    public void setDefaultSerializer(Serializer serializer) {
        this.defaultSerializer = serializer;
    }

    public Serializer getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public CoordinatedResourceConfig withDefaultSerializer(Serializer serializer) {
        this.setDefaultSerializer(serializer);
        return this;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.config.hasPath(RESOURCE_SERIALIZER) ? (Serializer)Configurable.load(this.config.getObject(RESOURCE_SERIALIZER).unwrapped()) : this.defaultSerializer);
    }

    public CoordinatedResourceConfig withSerializer(Serializer serializer) {
        this.setSerializer(serializer);
        return this;
    }

    public void setDefaultExecutor(Executor executor) {
        this.defaultExecutor = executor;
    }

    public Executor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public CoordinatedResourceConfig withDefaultExecutor(Executor executor) {
        this.setDefaultExecutor(executor);
        return this;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor != null ? this.executor : this.defaultExecutor;
    }

    public CoordinatedResourceConfig withExecutor(Executor executor) {
        this.setExecutor(executor);
        return this;
    }
}

