/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections;

import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.collections.AsyncCollectionConfig;
import net.kuujo.copycat.collections.internal.collection.DefaultAsyncSet;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.util.internal.Assert;

public class AsyncSetConfig
extends AsyncCollectionConfig<AsyncSetConfig> {
    private static final String DEFAULT_CONFIGURATION = "set-defaults";
    private static final String CONFIGURATION = "set";

    public AsyncSetConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public AsyncSetConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public AsyncSetConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected AsyncSetConfig(AsyncSetConfig config) {
        super(config);
    }

    @Override
    public AsyncSetConfig copy() {
        return new AsyncSetConfig(this);
    }

    @Override
    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config(this.getReplicas(), this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()), "Resource replica set must contain only active cluster members", new Object[0]);
        return new StateLogConfig(this.toMap()).resolve(cluster).withResourceType(DefaultAsyncSet.class);
    }
}

