/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections.internal.map;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.kuujo.copycat.collections.internal.map.MultiMapState;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;

public class DefaultMultiMapState<K, V>
implements MultiMapState<K, V> {
    private Map<K, Collection<V>> map;

    @Override
    @Initializer
    public void init(StateContext<MultiMapState<K, V>> context) {
        this.map = (Map)context.get("value");
        if (this.map == null) {
            this.map = new HashMap<K, Collection<V>>();
            context.put("value", this.map);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        for (Collection<V> values : this.map.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(K key, V value) {
        return this.map.containsKey(key) && this.map.get(key).contains(value);
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Collection<V> put(K key, V value) {
        Collection<V> values = this.map.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            this.map.put(key, values);
        }
        values.add(value);
        return values;
    }

    @Override
    public Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public boolean remove(K key, V value) {
        Collection<V> values = this.map.get(key);
        if (values != null) {
            boolean result = values.remove(value);
            if (values.isEmpty()) {
                this.map.remove(key);
            }
            return result;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.map.values().forEach(values::addAll);
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entries = new HashSet();
        for (Map.Entry entry : this.map.entrySet()) {
            entry.getValue().forEach(value -> entries.add(new AbstractMap.SimpleEntry(entry.getKey(), value)));
        }
        return entries;
    }

    @Override
    public Collection<V> getOrDefault(K key, Collection<V> defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Collection<V>, ? extends Collection<V>> function) {
        this.map.replaceAll(function);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Collection<V> values = this.map.get(key);
        if (values != null && values.remove(oldValue)) {
            values.add(newValue);
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> replace(K key, Collection<V> value) {
        return this.map.replace(key, value);
    }
}

