/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.election;

import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.election.internal.DefaultLeaderElection;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.util.internal.Assert;

public class LeaderElectionConfig
extends ResourceConfig<LeaderElectionConfig> {
    private static final String CONFIGURATION = "election";
    private static final String DEFAULT_CONFIGURATION = "election-defaults";

    public LeaderElectionConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public LeaderElectionConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public LeaderElectionConfig(String resource) {
        super(resource, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    private LeaderElectionConfig(LeaderElectionConfig config) {
        super(config);
    }

    @Override
    public LeaderElectionConfig copy() {
        return new LeaderElectionConfig(this);
    }

    @Override
    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config(this.getReplicas(), this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()), "Resource replica set must contain only active cluster members", new Object[0]);
        return new CoordinatedResourceConfig(super.toMap()).withElectionTimeout(this.getElectionTimeout()).withHeartbeatInterval(this.getHeartbeatInterval()).withExecutor(this.getExecutor()).withResourceType(DefaultLeaderElection.class).withLog(this.getLog()).withResourceConfig(this).withReplicas(this.getReplicas().isEmpty() ? cluster.getMembers() : this.getReplicas());
    }
}

