/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.election.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.EventListener;
import net.kuujo.copycat.cluster.ElectionEvent;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.election.LeaderElection;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;

public class DefaultLeaderElection
extends AbstractResource<LeaderElection>
implements LeaderElection {
    private final Map<EventListener<Member>, EventListener<ElectionEvent>> listeners = new HashMap<EventListener<Member>, EventListener<ElectionEvent>>();

    public DefaultLeaderElection(ResourceManager context) {
        super(context);
    }

    @Override
    public synchronized LeaderElection addListener(EventListener<Member> listener) {
        if (!this.listeners.containsKey(listener)) {
            EventListener wrapper = event -> listener.accept(event.winner());
            this.listeners.put(listener, wrapper);
            this.context.cluster().addElectionListener(wrapper);
        }
        return this;
    }

    @Override
    public synchronized LeaderElection removeListener(EventListener<Member> listener) {
        EventListener<ElectionEvent> wrapper = this.listeners.remove(listener);
        if (wrapper != null) {
            this.context.cluster().removeElectionListener(wrapper);
        }
        return this;
    }

    @Override
    public synchronized CompletableFuture<LeaderElection> open() {
        return ((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.context.open())).thenApply(v -> this);
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return this.context.close().thenCompose(v -> this.runShutdownTasks());
    }
}

