/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.event.retention;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.event.retention.RetentionPolicy;
import net.kuujo.copycat.log.LogSegment;
import net.kuujo.copycat.util.AbstractConfigurable;

public class TimeBasedRetentionPolicy
extends AbstractConfigurable
implements RetentionPolicy {
    private long time;

    public TimeBasedRetentionPolicy() {
    }

    public TimeBasedRetentionPolicy(long time, TimeUnit unit) {
        this.time = unit.toMillis(time);
    }

    public TimeBasedRetentionPolicy(Map<String, Object> config) {
        super(config, new String[0]);
    }

    private TimeBasedRetentionPolicy(TimeBasedRetentionPolicy policy) {
        super(policy);
    }

    @Override
    public TimeBasedRetentionPolicy copy() {
        return new TimeBasedRetentionPolicy(this);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setTime(long time, TimeUnit unit) {
        this.time = unit.toMillis(time);
    }

    public long getTime() {
        return this.time;
    }

    public TimeBasedRetentionPolicy withTime(long time) {
        this.time = time;
        return this;
    }

    public TimeBasedRetentionPolicy withTime(long time, TimeUnit unit) {
        this.time = unit.toMillis(time);
        return this;
    }

    @Override
    public boolean retain(LogSegment segment) {
        return System.currentTimeMillis() < segment.timestamp() + this.time;
    }
}

