/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.kuujo.copycat.Copycat;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.atomic.AsyncBoolean;
import net.kuujo.copycat.atomic.AsyncBooleanConfig;
import net.kuujo.copycat.atomic.AsyncLong;
import net.kuujo.copycat.atomic.AsyncLongConfig;
import net.kuujo.copycat.atomic.AsyncReference;
import net.kuujo.copycat.atomic.AsyncReferenceConfig;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.collections.AsyncList;
import net.kuujo.copycat.collections.AsyncListConfig;
import net.kuujo.copycat.collections.AsyncMap;
import net.kuujo.copycat.collections.AsyncMapConfig;
import net.kuujo.copycat.collections.AsyncMultiMap;
import net.kuujo.copycat.collections.AsyncMultiMapConfig;
import net.kuujo.copycat.collections.AsyncSet;
import net.kuujo.copycat.collections.AsyncSetConfig;
import net.kuujo.copycat.election.LeaderElection;
import net.kuujo.copycat.election.LeaderElectionConfig;
import net.kuujo.copycat.event.EventLog;
import net.kuujo.copycat.event.EventLogConfig;
import net.kuujo.copycat.state.StateLog;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.StateMachineConfig;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;

public class DefaultCopycat
implements Copycat {
    private final ClusterCoordinator coordinator;
    private final CopycatConfig config;
    private final Executor executor;

    public DefaultCopycat(CopycatConfig config) {
        this.coordinator = new DefaultClusterCoordinator(config.resolve());
        this.config = config;
        this.executor = config.getDefaultExecutor() != null ? config.getDefaultExecutor() : Executors.newSingleThreadExecutor(new NamedThreadFactory(config.getName() + "-%d"));
    }

    @Override
    public Cluster cluster() {
        return this.coordinator.cluster();
    }

    @Override
    public CopycatConfig config() {
        return this.config;
    }

    @Override
    public <T> EventLog<T> createEventLog(String name) {
        return this.createEventLog(name, new EventLogConfig(name));
    }

    @Override
    public <T> EventLog<T> createEventLog(String name, EventLogConfig config) {
        return (EventLog)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <T> StateLog<T> createStateLog(String name) {
        return this.createStateLog(name, new StateLogConfig(name));
    }

    @Override
    public <T> StateLog<T> createStateLog(String name, StateLogConfig config) {
        return (StateLog)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <T> StateMachine<T> createStateMachine(String name, Class<T> stateType, Class<? extends T> initialState) {
        return this.createStateMachine(name, new StateMachineConfig().withStateType(stateType).withInitialState(initialState));
    }

    @Override
    public <T> StateMachine<T> createStateMachine(String name, StateMachineConfig config) {
        return (StateMachine)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public LeaderElection createLeaderElection(String name) {
        return this.createLeaderElection(name, new LeaderElectionConfig(name));
    }

    @Override
    public LeaderElection createLeaderElection(String name, LeaderElectionConfig config) {
        return (LeaderElection)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <K, V> AsyncMap<K, V> createMap(String name) {
        return this.createMap(name, new AsyncMapConfig(name));
    }

    @Override
    public <K, V> AsyncMap<K, V> createMap(String name, AsyncMapConfig config) {
        return (AsyncMap)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <K, V> AsyncMultiMap<K, V> createMultiMap(String name) {
        return this.createMultiMap(name, new AsyncMultiMapConfig(name));
    }

    @Override
    public <K, V> AsyncMultiMap<K, V> createMultiMap(String name, AsyncMultiMapConfig config) {
        return (AsyncMultiMap)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <T> AsyncList<T> createList(String name) {
        return this.createList(name, new AsyncListConfig(name));
    }

    @Override
    public <T> AsyncList<T> createList(String name, AsyncListConfig config) {
        return (AsyncList)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <T> AsyncSet<T> createSet(String name) {
        return this.createSet(name, new AsyncSetConfig(name));
    }

    @Override
    public <T> AsyncSet<T> createSet(String name, AsyncSetConfig config) {
        return (AsyncSet)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public AsyncLong createLong(String name) {
        return this.createLong(name, new AsyncLongConfig());
    }

    @Override
    public AsyncLong createLong(String name, AsyncLongConfig config) {
        return (AsyncLong)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public AsyncBoolean createBoolean(String name) {
        return this.createBoolean(name, new AsyncBooleanConfig());
    }

    @Override
    public AsyncBoolean createBoolean(String name, AsyncBooleanConfig config) {
        return (AsyncBoolean)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public <T> AsyncReference<T> createReference(String name) {
        return this.createReference(name, new AsyncReferenceConfig());
    }

    @Override
    public <T> AsyncReference<T> createReference(String name, AsyncReferenceConfig config) {
        return (AsyncReference)this.coordinator.getResource(name, config.resolve(this.config.getClusterConfig()).withDefaultSerializer(this.config.getDefaultSerializer().copy()).withDefaultExecutor(this.config.getDefaultExecutor()));
    }

    @Override
    public CompletableFuture<Copycat> open() {
        return this.coordinator.open().thenApplyAsync(v -> this, this.executor);
    }

    @Override
    public boolean isOpen() {
        return this.coordinator.isOpen();
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.coordinator.close().thenRunAsync(() -> {}, this.executor);
    }

    @Override
    public boolean isClosed() {
        return this.coordinator.isClosed();
    }

    public String toString() {
        return String.format("%s[cluster=%s]", this.getClass().getSimpleName(), this.cluster());
    }
}

