/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.kuujo.copycat.log.AbstractLoggable;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.log.LogConfig;
import net.kuujo.copycat.log.LogException;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.log.LogSegment;
import net.kuujo.copycat.log.Loggable;
import net.kuujo.copycat.util.internal.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogManager
extends AbstractLoggable
implements LogManager {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Log config;
    protected final TreeMap<Long, LogSegment> segments = new TreeMap();
    protected LogSegment currentSegment;
    private long nextSegmentId;
    private long lastFlush;

    protected AbstractLogManager(Log config) {
        this.config = config.copy();
    }

    @Override
    public LogConfig config() {
        return this.config;
    }

    protected abstract Collection<LogSegment> loadSegments();

    protected abstract LogSegment createSegment(long var1, long var3);

    @Override
    public TreeMap<Long, LogSegment> segments() {
        return this.segments;
    }

    @Override
    public LogSegment segment() {
        return this.currentSegment;
    }

    @Override
    public LogSegment segment(long index) {
        this.assertIsOpen();
        Map.Entry<Long, LogSegment> segment = this.segments.floorEntry(index);
        Assert.index(index, segment != null, "Invalid log index %d", index);
        return segment.getValue();
    }

    @Override
    public LogSegment firstSegment() {
        this.assertIsOpen();
        Map.Entry<Long, LogSegment> segment = this.segments.firstEntry();
        return segment != null ? segment.getValue() : null;
    }

    @Override
    public LogSegment lastSegment() {
        this.assertIsOpen();
        Map.Entry<Long, LogSegment> segment = this.segments.lastEntry();
        return segment != null ? segment.getValue() : null;
    }

    @Override
    public synchronized void open() throws IOException {
        this.assertIsNotOpen();
        for (LogSegment segment : this.loadSegments()) {
            segment.open();
            this.segments.put(segment.index(), segment);
        }
        if (!this.segments.isEmpty()) {
            this.currentSegment = this.segments.lastEntry().getValue();
        } else {
            this.createInitialSegment();
        }
        this.clean();
    }

    private void clean() throws IOException {
        Long lastIndex = null;
        Long compactIndex = null;
        for (LogSegment segment : this.segments.values()) {
            if (segment.index() != this.segments.lastKey().longValue() && (lastIndex == null || segment.index() > lastIndex + 1L)) {
                compactIndex = segment.index();
            }
            lastIndex = segment.lastIndex();
        }
        if (compactIndex != null) {
            this.compact(compactIndex);
        }
    }

    @Override
    public boolean isOpen() {
        return this.currentSegment != null;
    }

    @Override
    public long size() {
        this.assertIsOpen();
        return this.segments.values().stream().mapToLong(Loggable::size).sum();
    }

    @Override
    public long entryCount() {
        this.assertIsOpen();
        return this.segments.values().stream().mapToLong(Loggable::entryCount).sum();
    }

    @Override
    public boolean isEmpty() {
        this.assertIsOpen();
        LogSegment firstSegment = this.firstSegment();
        return firstSegment == null || firstSegment.size() == 0L;
    }

    @Override
    public long appendEntry(ByteBuffer entry) throws IOException {
        this.assertIsOpen();
        this.checkRollOver();
        return this.currentSegment.appendEntry(entry);
    }

    @Override
    public long index() {
        this.assertIsOpen();
        LogSegment firstSegment = this.firstSegment();
        return firstSegment == null ? 1L : firstSegment.index();
    }

    @Override
    public Long firstIndex() {
        this.assertIsOpen();
        LogSegment firstSegment = this.firstSegment();
        return firstSegment == null ? null : firstSegment.firstIndex();
    }

    @Override
    public Long lastIndex() {
        this.assertIsOpen();
        LogSegment lastSegment = this.lastSegment();
        return lastSegment == null ? null : lastSegment.lastIndex();
    }

    @Override
    public boolean containsIndex(long index) {
        this.assertIsOpen();
        Long firstIndex = this.firstIndex();
        Long lastIndex = this.lastIndex();
        return firstIndex != null && lastIndex != null && firstIndex <= index && index <= lastIndex;
    }

    @Override
    public ByteBuffer getEntry(long index) {
        this.assertIsOpen();
        LogSegment segment = this.currentSegment.containsIndex(index) ? this.currentSegment : this.segment(index);
        return segment.getEntry(index);
    }

    @Override
    public void removeAfter(long index) {
        this.assertIsOpen();
        this.assertContainsIndex(index + 1L);
        Long segmentIndex = this.segments.floorKey(index < 1L ? 1L : index);
        Collection<LogSegment> removalSegments = this.segments.tailMap(segmentIndex).values();
        Iterator<LogSegment> i = removalSegments.iterator();
        while (i.hasNext()) {
            LogSegment segment = i.next();
            if (index < segment.index()) {
                segment.delete();
                i.remove();
                --this.nextSegmentId;
                continue;
            }
            segment.removeAfter(index);
        }
        LogSegment lastSegment = this.lastSegment();
        if (lastSegment != null) {
            this.currentSegment = lastSegment;
        } else {
            try {
                this.createInitialSegment();
            }
            catch (IOException e) {
                throw new LogException(e, "Failed to open new segment", new Object[0]);
            }
        }
    }

    @Override
    public void rollOver(long index) throws IOException {
        if (this.currentSegment.isEmpty()) {
            this.segments.remove(this.currentSegment.index());
            this.currentSegment.close();
            this.currentSegment.delete();
            this.currentSegment = null;
        } else {
            this.currentSegment.flush();
        }
        this.currentSegment = this.createSegment(++this.nextSegmentId, index);
        this.LOGGER.debug("Rolling over to new segment at new index {}", (Object)index);
        this.currentSegment.open();
        this.segments.put(index, this.currentSegment);
        this.lastFlush = System.currentTimeMillis();
    }

    @Override
    public void compact(long index) throws IOException {
        Assert.index(index, index >= this.index() && (this.lastIndex() == null || index <= this.lastIndex()), "%s is invalid for the log", index);
        Assert.arg(index, this.segments.containsKey(index), "%s must be the first index of a segment", index);
        this.LOGGER.debug("Compacting log at index {}", (Object)index);
        Iterator<Map.Entry<Long, LogSegment>> iterator = this.segments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, LogSegment> entry = iterator.next();
            LogSegment segment = entry.getValue();
            if (index <= segment.index()) continue;
            iterator.remove();
            segment.close();
            segment.delete();
        }
    }

    @Override
    public void flush() {
        this.assertIsOpen();
        if (this.config.isFlushOnWrite()) {
            this.currentSegment.flush();
        } else if (System.currentTimeMillis() - this.lastFlush > this.config.getFlushInterval()) {
            this.currentSegment.flush();
            this.lastFlush = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        for (LogSegment segment : this.segments.values()) {
            segment.close();
        }
        this.segments.clear();
        this.currentSegment = null;
    }

    @Override
    public boolean isClosed() {
        return this.currentSegment == null;
    }

    @Override
    public void delete() {
        for (LogSegment segment : this.segments.values()) {
            segment.delete();
        }
        this.segments.clear();
    }

    public String toString() {
        return this.segments.toString();
    }

    private void createInitialSegment() throws IOException {
        this.currentSegment = this.createSegment(++this.nextSegmentId, 1L);
        this.currentSegment.open();
        this.segments.put(1L, this.currentSegment);
    }

    private void checkRollOver() throws IOException {
        boolean segmentExpired;
        Long lastIndex = this.currentSegment.lastIndex();
        if (lastIndex == null) {
            return;
        }
        boolean segmentSizeExceeded = this.currentSegment.size() >= (long)this.config.getSegmentSize();
        boolean bl = segmentExpired = this.config.getSegmentInterval() < Long.MAX_VALUE && System.currentTimeMillis() > this.currentSegment.timestamp() + this.config.getSegmentInterval();
        if (segmentSizeExceeded || segmentExpired) {
            this.rollOver(lastIndex + 1L);
        }
    }
}

