/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.util.Map;
import net.kuujo.copycat.log.FileLogManager;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.util.internal.Assert;

public class FileLog
extends Log {
    private static final String FILE_LOG_DIRECTORY = "directory";

    public FileLog() {
    }

    public FileLog(Map<String, Object> config) {
        super(config, new String[0]);
    }

    protected FileLog(Map<String, Object> config, String ... resources) {
        super(config, resources);
    }

    public FileLog(String resource) {
        super(resource);
    }

    protected FileLog(String ... resources) {
        super(resources);
    }

    protected FileLog(FileLog log) {
        super(log);
    }

    @Override
    public FileLog copy() {
        return new FileLog(this);
    }

    public void setDirectory(String directory) {
        this.config = this.config.withValue(FILE_LOG_DIRECTORY, ConfigValueFactory.fromAnyRef(Assert.isNotNull(directory, FILE_LOG_DIRECTORY)));
    }

    public void setDirectory(File directory) {
        this.setDirectory(directory.getAbsolutePath());
    }

    public File getDirectory() {
        return new File(this.config.hasPath(FILE_LOG_DIRECTORY) ? this.config.getString(FILE_LOG_DIRECTORY) : System.getProperty("user.dir"));
    }

    public FileLog withDirectory(String directory) {
        this.setDirectory(directory);
        return this;
    }

    public FileLog withDirectory(File directory) {
        this.setDirectory(directory);
        return this;
    }

    @Override
    public FileLog withSegmentSize(int segmentSize) {
        this.setSegmentSize(segmentSize);
        return this;
    }

    @Override
    public FileLog withSegmentInterval(long segmentInterval) {
        this.setSegmentInterval(segmentInterval);
        return this;
    }

    @Override
    public FileLog withFlushOnWrite(boolean flushOnWrite) {
        this.setFlushOnWrite(flushOnWrite);
        return this;
    }

    @Override
    public FileLog withFlushInterval(long flushInterval) {
        this.setFlushInterval(flushInterval);
        return this;
    }

    @Override
    public LogManager getLogManager(String name) {
        return new FileLogManager(name, this);
    }
}

