/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.netty;

import com.typesafe.config.ConfigValueFactory;
import java.net.URI;
import java.util.Map;
import net.kuujo.copycat.netty.NettyTcpProtocolClient;
import net.kuujo.copycat.netty.NettyTcpProtocolServer;
import net.kuujo.copycat.protocol.AbstractProtocol;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.internal.Assert;

public class NettyTcpProtocol
extends AbstractProtocol {
    private static final String NETTY_EVENT_LOOP_THREADS = "event-loop.threads";
    private static final String NETTY_SEND_BUFFER_SIZE = "send.buffer.size";
    private static final String NETTY_RECEIVE_BUFFER_SIZE = "receive.buffer.size";
    private static final String NETTY_USE_SSL = "ssl.enabled";
    private static final String NETTY_SO_LINGER = "solinger";
    private static final String NETTY_TRAFFIC_CLASS = "traffic.class";
    private static final String NETTY_ACCEPT_BACKLOG = "accept.backlog";
    private static final String NETTY_CONNECT_TIMEOUT = "connect.timeout";
    private static final String CONFIGURATION = "tcp";
    private static final String DEFAULT_CONFIGURATION = "tcp-defaults";

    public NettyTcpProtocol() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public NettyTcpProtocol(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public NettyTcpProtocol(String resource) {
        super(NettyTcpProtocol.addResources(new String[]{resource}, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    private NettyTcpProtocol(NettyTcpProtocol protocol) {
        super(protocol);
    }

    @Override
    public Configurable copy() {
        return new NettyTcpProtocol(this);
    }

    public void setThreads(int numThreads) {
        this.config = this.config.withValue(NETTY_EVENT_LOOP_THREADS, ConfigValueFactory.fromAnyRef(Assert.arg(numThreads, numThreads > 0, "number of threads must be positive", new Object[0])));
    }

    public int getThreads() {
        return this.config.getInt(NETTY_EVENT_LOOP_THREADS);
    }

    public NettyTcpProtocol withThreads(int numThreads) {
        this.setThreads(numThreads);
        return this;
    }

    public void setSendBufferSize(int bufferSize) {
        this.config = this.config.withValue(NETTY_SEND_BUFFER_SIZE, ConfigValueFactory.fromAnyRef(Assert.arg(bufferSize, bufferSize > 0, "buffer size must be positive", new Object[0])));
    }

    public int getSendBufferSize() {
        return this.config.getInt(NETTY_SEND_BUFFER_SIZE);
    }

    public NettyTcpProtocol withSendBufferSize(int bufferSize) {
        this.setSendBufferSize(bufferSize);
        return this;
    }

    public void setReceiveBufferSize(int bufferSize) {
        this.config = this.config.withValue(NETTY_RECEIVE_BUFFER_SIZE, ConfigValueFactory.fromAnyRef(Assert.arg(bufferSize, bufferSize > 0, "buffer size must be positive", new Object[0])));
    }

    public int getReceiveBufferSize() {
        return this.config.getInt(NETTY_RECEIVE_BUFFER_SIZE);
    }

    public NettyTcpProtocol withReceiveBufferSize(int bufferSize) {
        this.setReceiveBufferSize(bufferSize);
        return this;
    }

    public void setSsl(boolean useSsl) {
        this.config = this.config.withValue(NETTY_USE_SSL, ConfigValueFactory.fromAnyRef(useSsl));
    }

    public boolean isSsl() {
        return this.config.getBoolean(NETTY_USE_SSL);
    }

    public NettyTcpProtocol withSsl(boolean useSsl) {
        this.setSsl(useSsl);
        return this;
    }

    public void setSoLinger(int soLinger) {
        this.config = this.config.withValue(NETTY_SO_LINGER, ConfigValueFactory.fromAnyRef(soLinger));
    }

    public int getSoLinger() {
        return this.config.getInt(NETTY_SO_LINGER);
    }

    public NettyTcpProtocol withSoLinger(int soLinger) {
        this.setSoLinger(soLinger);
        return this;
    }

    public void setTrafficClass(int trafficClass) {
        this.config = this.config.withValue(NETTY_TRAFFIC_CLASS, ConfigValueFactory.fromAnyRef(trafficClass));
    }

    public int getTrafficClass() {
        return this.config.getInt(NETTY_TRAFFIC_CLASS);
    }

    public NettyTcpProtocol withTrafficClass(int trafficClass) {
        this.setTrafficClass(trafficClass);
        return this;
    }

    public void setAcceptBacklog(int backlog) {
        this.config = this.config.withValue(NETTY_ACCEPT_BACKLOG, ConfigValueFactory.fromAnyRef(Assert.arg(backlog, backlog > 0, "accept backlog must be positive", new Object[0])));
    }

    public int getAcceptBacklog() {
        return this.config.getInt(NETTY_ACCEPT_BACKLOG);
    }

    public NettyTcpProtocol withAcceptBacklog(int backlog) {
        this.setAcceptBacklog(backlog);
        return this;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.config = this.config.withValue(NETTY_CONNECT_TIMEOUT, ConfigValueFactory.fromAnyRef(Assert.arg(connectTimeout, connectTimeout > 0, "connect timeout must be positive", new Object[0])));
    }

    public int getConnectTimeout() {
        return this.config.getInt(NETTY_CONNECT_TIMEOUT);
    }

    public NettyTcpProtocol withConnectTimeout(int connectTimeout) {
        this.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public ProtocolServer createServer(URI uri) {
        return new NettyTcpProtocolServer(uri.getHost(), uri.getPort(), this);
    }

    @Override
    public ProtocolClient createClient(URI uri) {
        return new NettyTcpProtocolClient(uri.getHost(), uri.getPort(), this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

