/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.kuujo.copycat.netty.NettyTcpProtocol;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolException;

public class NettyTcpProtocolClient
implements ProtocolClient {
    private final String host;
    private final int port;
    private final NettyTcpProtocol protocol;
    private EventLoopGroup group;
    private Channel channel;
    private ChannelHandlerContext context;
    private final Map<Object, CompletableFuture<ByteBuffer>> responseFutures = new HashMap<Object, CompletableFuture<ByteBuffer>>(1000);
    private long requestId;
    private final ChannelInboundHandlerAdapter channelHandler = new SimpleChannelInboundHandler<byte[]>(){

        public void channelActive(ChannelHandlerContext context) {
            NettyTcpProtocolClient.this.context = context;
        }

        protected void channelRead0(ChannelHandlerContext context, byte[] message) throws Exception {
            ByteBuffer buffer = ByteBuffer.wrap(message);
            long responseId = buffer.getLong();
            CompletableFuture responseFuture = (CompletableFuture)NettyTcpProtocolClient.this.responseFutures.remove(responseId);
            if (responseFuture != null) {
                responseFuture.complete(buffer.slice());
            }
        }
    };

    public NettyTcpProtocolClient(String host, int port, NettyTcpProtocol protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    @Override
    public CompletableFuture<ByteBuffer> write(ByteBuffer request) {
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        if (this.channel != null) {
            long requestId = ++this.requestId;
            ByteBuffer buffer = ByteBuffer.allocate(request.limit() + 8);
            buffer.putLong(requestId);
            buffer.put(request);
            this.channel.writeAndFlush((Object)buffer.array()).addListener(channelFuture -> {
                if (channelFuture.isSuccess()) {
                    this.responseFutures.put(requestId, future);
                } else {
                    future.completeExceptionally(new ProtocolException(channelFuture.cause()));
                }
            });
        } else {
            future.completeExceptionally(new ProtocolException("Client not connected", new Object[0]));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> connect() {
        SslContext sslContext;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.channel != null) {
            future.complete(null);
            return future;
        }
        if (this.protocol.isSsl()) {
            try {
                sslContext = SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE);
            }
            catch (SSLException e) {
                future.completeExceptionally(e);
                return future;
            }
        } else {
            sslContext = null;
        }
        this.group = new NioEventLoopGroup(this.protocol.getThreads());
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (sslContext != null) {
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc(), NettyTcpProtocolClient.this.host, NettyTcpProtocolClient.this.port)});
                }
                pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4));
                pipeline.addLast("bytesDecoder", (ChannelHandler)new ByteArrayDecoder());
                pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("bytesEncoder", (ChannelHandler)new ByteArrayEncoder());
                pipeline.addLast("handler", (ChannelHandler)NettyTcpProtocolClient.this.channelHandler);
            }
        });
        if (this.protocol.getSendBufferSize() > -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.protocol.getSendBufferSize());
        }
        if (this.protocol.getReceiveBufferSize() > -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.protocol.getReceiveBufferSize());
        }
        if (this.protocol.getTrafficClass() > -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)this.protocol.getTrafficClass());
        }
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_LINGER, (Object)this.protocol.getSoLinger());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.protocol.getConnectTimeout());
        bootstrap.connect(this.host, this.port).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.channel = channelFuture.channel();
                future.complete(null);
            } else {
                future.completeExceptionally(channelFuture.cause());
            }
        }));
        return future;
    }

    @Override
    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.channel != null) {
            this.channel.close().addListener(channelFuture -> {
                this.group.shutdownGracefully();
                if (channelFuture.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(channelFuture.cause());
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

