/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;
import net.kuujo.copycat.netty.NettyTcpProtocol;
import net.kuujo.copycat.protocol.ProtocolHandler;
import net.kuujo.copycat.protocol.ProtocolServer;

public class NettyTcpProtocolServer
implements ProtocolServer {
    private final String host;
    private final int port;
    private final NettyTcpProtocol protocol;
    private ProtocolHandler handler;
    private EventLoopGroup serverGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public NettyTcpProtocolServer(String host, int port, NettyTcpProtocol protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    @Override
    public void handler(ProtocolHandler handler) {
        this.handler = handler;
    }

    @Override
    public synchronized CompletableFuture<Void> listen() {
        SslContext sslContext;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.protocol.isSsl()) {
            try {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                sslContext = SslContext.newServerContext((File)ssc.certificate(), (File)ssc.privateKey());
            }
            catch (CertificateException | SSLException e) {
                future.completeExceptionally(e);
                return future;
            }
        } else {
            sslContext = null;
        }
        this.serverGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup(this.protocol.getThreads());
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.serverGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (sslContext != null) {
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                }
                pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4));
                pipeline.addLast("bytesDecoder", (ChannelHandler)new ByteArrayDecoder());
                pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("bytesEncoder", (ChannelHandler)new ByteArrayEncoder());
                pipeline.addLast("handler", (ChannelHandler)new ServerHandler());
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128);
        if (this.protocol.getSendBufferSize() > -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.protocol.getSendBufferSize());
        }
        if (this.protocol.getReceiveBufferSize() > -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.protocol.getReceiveBufferSize());
        }
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.protocol.getAcceptBacklog());
        if (this.protocol.getTrafficClass() > -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)this.protocol.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.bind(this.host, this.port).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            channelFuture.channel().closeFuture().addListener(closeFuture -> this.workerGroup.shutdownGracefully());
            if (channelFuture.isSuccess()) {
                this.channel = channelFuture.channel();
                future.complete(null);
            } else {
                future.completeExceptionally(channelFuture.cause());
            }
        }));
        return future;
    }

    @Override
    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.channel != null) {
            this.channel.close().addListener(channelFuture -> {
                this.workerGroup.shutdownGracefully();
                this.serverGroup.shutdownGracefully();
                if (channelFuture.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(channelFuture.cause());
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class ServerHandler
    extends SimpleChannelInboundHandler<byte[]> {
        private ServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext context, byte[] message) throws Exception {
            if (NettyTcpProtocolServer.this.handler != null) {
                ByteBuffer buffer = ByteBuffer.wrap(message);
                long requestId = buffer.getLong();
                ((CompletableFuture)NettyTcpProtocolServer.this.handler.apply(buffer.slice())).whenComplete((result, error) -> {
                    if (error == null) {
                        context.channel().eventLoop().execute(() -> {
                            ByteBuffer response = ByteBuffer.allocate(result.limit() + 8);
                            response.putLong(requestId);
                            response.put((ByteBuffer)result);
                            context.writeAndFlush((Object)response.array());
                        });
                    }
                });
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            context.close();
        }
    }
}

