/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.kuujo.copycat.protocol.LocalProtocolServer;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolException;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;

public class LocalProtocolClient
implements ProtocolClient {
    private final Executor executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("copycat-protocol-thread-%d"));
    private final String address;
    private final Map<String, LocalProtocolServer> registry;

    public LocalProtocolClient(String address, Map<String, LocalProtocolServer> registry) {
        this.address = address;
        this.registry = registry;
    }

    @Override
    public CompletableFuture<ByteBuffer> write(ByteBuffer request) {
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        this.executor.execute(() -> {
            LocalProtocolServer server = this.registry.get(this.address);
            if (server != null) {
                server.handle(request).whenComplete((response, error) -> {
                    if (error != null) {
                        this.executor.execute(() -> future.completeExceptionally((Throwable)error));
                    } else {
                        this.executor.execute(() -> future.complete((ByteBuffer)response));
                    }
                });
            } else {
                future.completeExceptionally(new ProtocolException(String.format("Invalid server address %s", this.address), new Object[0]));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> connect() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }
}

