/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.raft.PassiveState;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.raft.RaftState;
import net.kuujo.copycat.raft.protocol.AppendRequest;
import net.kuujo.copycat.raft.protocol.AppendResponse;
import net.kuujo.copycat.raft.protocol.PollRequest;
import net.kuujo.copycat.raft.protocol.PollResponse;
import net.kuujo.copycat.raft.protocol.Request;
import net.kuujo.copycat.raft.protocol.VoteRequest;
import net.kuujo.copycat.raft.protocol.VoteResponse;

abstract class ActiveState
extends PassiveState {
    protected boolean transition;

    protected ActiveState(RaftContext context) {
        super(context);
    }

    protected CompletableFuture<RaftState.Type> transition(RaftState.Type state) {
        if (this.transitionHandler != null) {
            return (CompletableFuture)this.transitionHandler.apply(state);
        }
        return this.exceptionalFuture(new IllegalStateException("No transition handler registered"));
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        CompletableFuture<AppendResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleAppend(this.logRequest(request))));
        if (this.transition) {
            this.transition(RaftState.Type.FOLLOWER);
            this.transition = false;
        }
        return future;
    }

    private AppendResponse handleAppend(AppendRequest request) {
        if (request.term() > this.context.getTerm() || request.term() == this.context.getTerm() && this.context.getLeader() == null) {
            this.context.setTerm(request.term());
            this.context.setLeader(request.leader());
            this.transition = true;
        }
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.warn("{} - Rejected {}: request term is less than the current term ({})", new Object[]{this.context.getLocalMember(), request, this.context.getTerm()});
            return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
        }
        if (request.logIndex() != null && request.logTerm() != null) {
            return this.doCheckPreviousEntry(request);
        }
        return this.doAppendEntries(request);
    }

    private AppendResponse doCheckPreviousEntry(AppendRequest request) {
        if (request.logIndex() != null && this.context.log().lastIndex() == null) {
            this.LOGGER.warn("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getLocalMember(), request, request.logIndex(), this.context.log().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
        }
        if (request.logIndex() != null && this.context.log().lastIndex() != null && request.logIndex() > this.context.log().lastIndex()) {
            this.LOGGER.warn("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getLocalMember(), request, request.logIndex(), this.context.log().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
        }
        if (!this.context.log().containsIndex(request.logIndex())) {
            this.LOGGER.warn("{} - Rejected {}: Request entry not found in local log", (Object)this.context.getLocalMember(), (Object)request);
            return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
        }
        ByteBuffer entry = this.context.log().getEntry(request.logIndex());
        long localLogTerm = entry.getLong();
        if (localLogTerm != request.logTerm()) {
            AppendResponse response = ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
            this.LOGGER.warn("{} - Rejected {}: Request entry term does not match local log. Local log term is {}. Replying with {}", new Object[]{this.context.getLocalMember(), request, localLogTerm, response});
            return response;
        }
        return this.doAppendEntries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppendResponse doAppendEntries(AppendRequest request) {
        if (!request.entries().isEmpty()) {
            long index = request.logIndex() != null ? request.logIndex() : 0L;
            Long rollOverIndex = null;
            if (request.firstIndex() && (this.context.log().segment().firstIndex() == null || this.context.log().segment().firstIndex() != index + 1L)) {
                rollOverIndex = index + 1L;
                try {
                    this.context.log().rollOver(rollOverIndex);
                }
                catch (IOException e) {
                    this.LOGGER.error("{} - Failed to roll over local log", (Object)this.context.getLocalMember());
                    if (!this.context.log().isEmpty()) {
                        this.doApplyCommits(Math.min(this.context.log().lastIndex(), request.commitIndex()));
                    }
                    return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
                }
            }
            for (ByteBuffer entry : request.entries()) {
                if (this.context.log().containsIndex(++index)) {
                    ByteBuffer match = this.context.log().getEntry(index);
                    if (entry.getLong() == match.getLong()) continue;
                    this.LOGGER.warn("{} - Synced entry does not match local log, removing incorrect entries", (Object)this.context.getLocalMember());
                    try {
                        this.context.log().removeAfter(index - 1L);
                        this.context.log().appendEntry(entry);
                    }
                    catch (IOException e) {
                        this.doApplyCommits(request.commitIndex());
                        return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
                    }
                    this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getLocalMember(), entry, index});
                    continue;
                }
                try {
                    this.context.log().appendEntry(entry);
                }
                catch (IOException e) {
                    this.doApplyCommits(request.commitIndex());
                    return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
                }
                this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getLocalMember(), entry, index});
            }
            try {
                if (rollOverIndex != null) {
                    this.context.log().compact(rollOverIndex);
                }
            }
            catch (IOException e) {
                this.LOGGER.error("{} - Failed to roll over local log", (Object)this.context.getLocalMember());
                this.doApplyCommits(request.commitIndex());
                AppendResponse appendResponse = ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.log().lastIndex()).build();
                return appendResponse;
            }
            finally {
                this.context.log().flush();
            }
        }
        this.doApplyCommits(request.commitIndex());
        return ((AppendResponse.Builder)AppendResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withSucceeded(true).withLogIndex(this.context.log().lastIndex()).build();
    }

    private void doApplyCommits(Long commitIndex) {
        if (commitIndex != null && !this.context.log().isEmpty()) {
            Long lastIndex;
            this.LOGGER.debug("{} - Applying {} commits", (Object)this.context.getLocalMember(), (Object)(this.context.getLastApplied() != null ? commitIndex - Math.max(this.context.getLastApplied(), this.context.log().firstIndex()) : commitIndex));
            if ((this.context.getCommitIndex() == null || commitIndex > this.context.getCommitIndex() || this.context.getCommitIndex() > this.context.getLastApplied()) && (lastIndex = this.context.log().lastIndex()) != null) {
                this.context.setCommitIndex(Math.min(Math.max(commitIndex, this.context.getCommitIndex() != null ? this.context.getCommitIndex() : commitIndex), lastIndex));
                if (this.context.getLastApplied() == null || this.context.getCommitIndex() > this.context.getLastApplied()) {
                    for (long i = (this.context.getLastApplied() != null ? Long.valueOf(this.context.getLastApplied() + 1L) : this.context.log().firstIndex()).longValue(); i <= Math.min(this.context.getCommitIndex(), lastIndex); ++i) {
                        this.applyEntry(i);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyEntry(long index) {
        if (this.context.getLastApplied() == null && index == this.context.log().firstIndex() || this.context.getLastApplied() != null && this.context.getLastApplied() == index - 1L) {
            ByteBuffer entry = this.context.log().getEntry(index);
            long term = entry.getLong();
            ByteBuffer userEntry = entry.slice();
            try {
                this.context.consumer().apply(term, index, userEntry);
            }
            catch (Exception e) {
            }
            finally {
                this.context.setLastApplied(index);
            }
        }
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        this.context.checkThread();
        return CompletableFuture.completedFuture(this.logResponse(this.handlePoll(this.logRequest(request))));
    }

    protected PollResponse handlePoll(PollRequest request) {
        if (this.logUpToDate(request.logIndex(), request.logTerm(), request)) {
            return ((PollResponse.Builder)PollResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withAccepted(true).build();
        }
        return ((PollResponse.Builder)PollResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withAccepted(false).build();
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        this.context.checkThread();
        return CompletableFuture.completedFuture(this.logResponse(this.handleVote(this.logRequest(request))));
    }

    protected VoteResponse handleVote(VoteRequest request) {
        if (request.term() > this.context.getTerm()) {
            this.context.setTerm(request.term());
        }
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.debug("{} - Rejected {}: candidate's term is less than the current term", (Object)this.context.getLocalMember(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (request.candidate().equals(this.context.getLocalMember())) {
            this.context.setLastVotedFor(this.context.getLocalMember());
            this.LOGGER.debug("{} - Accepted {}: candidate is the local member", (Object)this.context.getLocalMember(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(true).build();
        }
        if (!this.context.getMembers().contains(request.candidate())) {
            this.LOGGER.debug("{} - Rejected {}: candidate is not known to the local member", (Object)this.context.getLocalMember(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLastVotedFor() == null || this.context.getLastVotedFor().equals(request.candidate())) {
            if (this.logUpToDate(request.logIndex(), request.logTerm(), request)) {
                this.context.setLastVotedFor(request.candidate());
                return ((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(true).build();
            }
            return ((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        this.LOGGER.debug("{} - Rejected {}: already voted for {}", new Object[]{this.context.getLocalMember(), request, this.context.getLastVotedFor()});
        return ((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(false).build();
    }

    private boolean logUpToDate(Long index, Long term, Request request) {
        if (this.context.log().isEmpty()) {
            this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getLocalMember(), (Object)request);
            return true;
        }
        Long lastIndex = this.context.log().lastIndex();
        if (lastIndex != null) {
            ByteBuffer entry = this.context.log().getEntry(lastIndex);
            if (entry == null) {
                this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getLocalMember(), (Object)request);
                return true;
            }
            long lastTerm = entry.getLong();
            if (index != null && index >= lastIndex) {
                if (term >= lastTerm) {
                    this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getLocalMember(), (Object)request);
                    return true;
                }
                this.LOGGER.debug("{} - Rejected {}: candidate's last log term ({}) is in conflict with local log ({})", new Object[]{this.context.getLocalMember(), request, term, lastTerm});
                return false;
            }
            this.LOGGER.debug("{} - Rejected {}: candidate's last log entry ({}) is at a lower index than the local log ({})", new Object[]{this.context.getLocalMember(), request, index, lastIndex});
            return false;
        }
        this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getLocalMember(), (Object)request);
        return true;
    }
}

