/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.copycat.raft.ActiveState;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.raft.RaftState;
import net.kuujo.copycat.raft.protocol.AppendRequest;
import net.kuujo.copycat.raft.protocol.AppendResponse;
import net.kuujo.copycat.raft.protocol.VoteRequest;
import net.kuujo.copycat.raft.protocol.VoteResponse;
import net.kuujo.copycat.util.internal.Quorum;

class CandidateState
extends ActiveState {
    private final Random random = new Random();
    private Quorum quorum;
    private ScheduledFuture<?> currentTimer;

    public CandidateState(RaftContext context) {
        super(context);
    }

    @Override
    public RaftState.Type type() {
        return RaftState.Type.CANDIDATE;
    }

    @Override
    public synchronized CompletableFuture<Void> open() {
        return super.open().thenRun(this::startElection);
    }

    private void startElection() {
        this.LOGGER.info("{} - Starting election", (Object)this.context.getLocalMember());
        this.sendVoteRequests();
    }

    private void sendVoteRequests() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel(false);
        }
        this.context.setTerm(this.context.getTerm() + 1L);
        long delay = this.context.getElectionTimeout() + (long)this.random.nextInt((int)this.context.getElectionTimeout()) % this.context.getElectionTimeout();
        this.currentTimer = this.context.executor().schedule(() -> {
            this.LOGGER.info("{} - Election timed out", (Object)this.context.getLocalMember());
            if (this.quorum != null) {
                this.quorum.cancel();
                this.quorum = null;
            }
            this.sendVoteRequests();
            this.LOGGER.info("{} - Restarted election", (Object)this.context.getLocalMember());
        }, delay, TimeUnit.MILLISECONDS);
        AtomicBoolean complete = new AtomicBoolean();
        Quorum quorum = new Quorum(1 + (int)Math.floor((double)this.context.getActiveMembers().size() / 2.0), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.transition(RaftState.Type.LEADER);
            }
        });
        Long lastIndex = this.context.log().lastIndex();
        ByteBuffer lastEntry = lastIndex != null ? this.context.log().getEntry(lastIndex) : null;
        this.LOGGER.info("{} - Requesting votes from {}", (Object)this.context.getLocalMember(), this.context.getActiveMembers());
        Long lastTerm = lastEntry != null ? Long.valueOf(lastEntry.getLong()) : null;
        for (String member : this.context.getActiveMembers()) {
            this.LOGGER.debug("{} - Requesting vote from {} for term {}", new Object[]{this.context.getLocalMember(), member, this.context.getTerm()});
            VoteRequest request = ((VoteRequest.Builder)VoteRequest.builder().withUri(member)).withTerm(this.context.getTerm()).withCandidate(this.context.getLocalMember()).withLogIndex(lastIndex).withLogTerm(lastTerm).build();
            ((CompletableFuture)this.voteHandler.apply(request)).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.LOGGER.debug("{} - Failed vote request to {}. Reason: {}", new Object[]{this.context.getLocalMember(), member, error.getMessage()});
                        quorum.fail();
                    } else if (response.term() > this.context.getTerm()) {
                        this.LOGGER.debug("{} - Received greater term from {}", (Object)this.context.getLocalMember(), (Object)member);
                        this.context.setTerm(response.term());
                        complete.set(true);
                        this.transition(RaftState.Type.FOLLOWER);
                    } else if (!response.voted()) {
                        this.LOGGER.info("{} - Received rejected vote from {}", (Object)this.context.getLocalMember(), (Object)member);
                        quorum.fail();
                    } else if (response.term() != this.context.getTerm()) {
                        this.LOGGER.info("{} - Received successful vote for a different term from {}", (Object)this.context.getLocalMember(), (Object)member);
                        quorum.fail();
                    } else {
                        this.LOGGER.info("{} - Received successful vote from {}", (Object)this.context.getLocalMember(), (Object)member);
                        quorum.succeed();
                    }
                }
            }, (Executor)this.context.executor());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        if (request.term() >= this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.transition(RaftState.Type.FOLLOWER);
        }
        return super.append(request);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        this.context.checkThread();
        if (request.term() > this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.transition(RaftState.Type.FOLLOWER);
            return super.vote(request);
        }
        if (request.candidate().equals(this.context.getLocalMember())) {
            return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(true).build()));
        }
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withUri(this.context.getLocalMember())).withTerm(this.context.getTerm()).withVoted(false).build()));
    }

    private void cancelElection() {
        this.context.checkThread();
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Cancelling election", (Object)this.context.getLocalMember());
            this.currentTimer.cancel(false);
        }
        if (this.quorum != null) {
            this.quorum.cancel();
            this.quorum = null;
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelElection);
    }
}

