/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.raft.RaftState;
import net.kuujo.copycat.raft.protocol.CommitRequest;
import net.kuujo.copycat.raft.protocol.CommitResponse;
import net.kuujo.copycat.raft.protocol.QueryRequest;
import net.kuujo.copycat.raft.protocol.QueryResponse;
import net.kuujo.copycat.raft.protocol.ReplicaInfo;
import net.kuujo.copycat.raft.protocol.Response;
import net.kuujo.copycat.raft.protocol.SyncRequest;
import net.kuujo.copycat.raft.protocol.SyncResponse;

public class PassiveState
extends RaftState {
    private static final int MAX_BATCH_SIZE = 0x100000;
    private ScheduledFuture<?> currentTimer;

    public PassiveState(RaftContext context) {
        super(context);
    }

    @Override
    public RaftState.Type type() {
        return RaftState.Type.PASSIVE;
    }

    @Override
    public synchronized CompletableFuture<Void> open() {
        return super.open().thenRun(this::startSyncTimer);
    }

    private void startSyncTimer() {
        this.LOGGER.debug("{} - Setting sync timer", (Object)this.context.getLocalMember());
        this.currentTimer = this.context.executor().scheduleAtFixedRate(this::sync, 1L, this.context.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
    }

    private void sync() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        ArrayList<ReplicaInfo> passiveMembers = new ArrayList<ReplicaInfo>(this.context.getMembers().size());
        for (String uri : this.context.getMembers()) {
            if (uri.equals(this.context.getLocalMember()) || this.context.getActiveMembers().contains(uri)) continue;
            ReplicaInfo member = this.context.getMemberInfo(uri);
            if (member == null) {
                member = new ReplicaInfo(uri);
                this.context.addMemberInfo(member);
            }
            passiveMembers.add(member);
        }
        Random random = new Random();
        ArrayList randomMembers = new ArrayList(3);
        for (int i = 0; i < Math.min(passiveMembers.size(), 3); ++i) {
            randomMembers.add(passiveMembers.get(random.nextInt(Math.min(passiveMembers.size(), 3))));
        }
        this.context.setVersion(this.context.getVersion() + 1L);
        HashSet<String> synchronizing = new HashSet<String>();
        for (ReplicaInfo member : randomMembers) {
            if (!synchronizing.add(member.getUri())) continue;
            this.recursiveSync(member).whenComplete((result, error) -> synchronizing.remove(member.getUri()));
        }
    }

    private CompletableFuture<Void> recursiveSync(ReplicaInfo member) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.recursiveSync(member, false, future);
        return future;
    }

    private void recursiveSync(ReplicaInfo member, boolean requireEntries, CompletableFuture<Void> future) {
        ArrayList<ByteBuffer> entries = new ArrayList<ByteBuffer>(1024);
        Long firstIndex = null;
        if (!this.context.log().isEmpty() && this.context.getCommitIndex() != null) {
            ByteBuffer entry;
            firstIndex = Math.max(member.getIndex() != null ? member.getIndex() + 1L : this.context.log().firstIndex(), this.context.log().lastIndex());
            long index = firstIndex;
            for (int size = 0; size < 0x100000 && index <= this.context.getCommitIndex(); size += entry.limit(), ++index) {
                entry = this.context.log().getEntry(index);
                entries.add(entry);
            }
        }
        if (!requireEntries || !entries.isEmpty()) {
            SyncRequest request = ((SyncRequest.Builder)SyncRequest.builder().withUri(member.getUri())).withLeader(this.context.getLeader()).withTerm(this.context.getTerm()).withLogIndex(member.getIndex()).withFirstIndex(firstIndex != null && firstIndex.equals(this.context.log().firstIndex())).withMembers(this.context.getMemberInfo()).withEntries(entries).build();
            this.LOGGER.debug("{} - Sending sync request to {}", (Object)this.context.getLocalMember(), (Object)member.getUri());
            ((CompletableFuture)this.syncHandler.apply(request)).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen()) {
                    if (error == null) {
                        if (response.status() == Response.Status.OK) {
                            this.context.setMemberInfo(response.members());
                        } else {
                            this.LOGGER.warn("{} - Received error response from {}", (Object)this.context.getLocalMember(), (Object)member.getUri());
                            future.completeExceptionally(response.error());
                        }
                    } else {
                        this.LOGGER.debug("{} - Sync to {} failed: {}", new Object[]{this.context.getLocalMember(), member, error.getMessage()});
                        future.completeExceptionally((Throwable)error);
                    }
                }
            }, (Executor)this.context.executor());
        } else {
            future.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        this.context.checkThread();
        if (request.term() > this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.context.setLeader(request.leader());
        } else if (request.term() == this.context.getTerm() && this.context.getLeader() == null && request.leader() != null) {
            this.context.setLeader(request.leader());
        }
        this.context.setVersion(this.context.getVersion() + 1L);
        this.context.setMemberInfo(request.members());
        if (!request.firstIndex() && request.logIndex() != null && !this.context.log().containsIndex(request.logIndex())) {
            return CompletableFuture.completedFuture(this.logResponse(((SyncResponse.Builder)SyncResponse.builder().withUri(this.context.getLocalMember())).withMembers(this.context.getMemberInfo()).build()));
        }
        Long rollOverIndex = null;
        if (!request.entries().isEmpty() && request.logIndex() != null && request.firstIndex()) {
            rollOverIndex = request.logIndex() + 1L;
            try {
                this.context.log().rollOver(rollOverIndex);
            }
            catch (IOException e) {
                this.LOGGER.error("{} - Failed to roll over log", (Object)this.context.getLocalMember());
                return CompletableFuture.completedFuture(this.logResponse(((SyncResponse.Builder)SyncResponse.builder().withUri(this.context.getLocalMember())).withMembers(this.context.getMemberInfo()).build()));
            }
        }
        for (int i = 0; i < request.entries().size(); ++i) {
            long index;
            long l = index = request.logIndex() != null ? request.logIndex() + (long)i + 1L : (long)(i + 1);
            if (this.context.log().containsIndex(index)) continue;
            ByteBuffer entry = request.entries().get(i);
            try {
                this.context.log().appendEntry(entry);
                this.context.setCommitIndex(index);
                long term = entry.getLong();
                ByteBuffer userEntry = entry.slice();
                try {
                    this.context.consumer().apply(term, index, userEntry);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.context.setLastApplied(index);
                this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getLocalMember(), entry, index});
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        try {
            if (rollOverIndex != null) {
                this.context.log().compact(rollOverIndex);
            }
        }
        catch (IOException e) {
            this.LOGGER.error("{} - Failed to compact log", (Object)this.context.getLocalMember());
        }
        finally {
            this.context.log().flush();
        }
        return CompletableFuture.completedFuture(this.logResponse(((SyncResponse.Builder)SyncResponse.builder().withUri(this.context.getLocalMember())).withMembers(this.context.getMemberInfo()).build()));
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (request.consistency() == Consistency.WEAK) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)QueryResponse.builder().withUri(this.context.getLocalMember())).withResult(this.context.consumer().apply(this.context.getTerm(), null, request.entry())).build()));
        }
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withUri(this.context.getLocalMember())).withStatus(Response.Status.ERROR)).withError(new IllegalStateException("Not the leader"))).build()));
        }
        return (CompletableFuture)this.queryHandler.apply(((QueryRequest.Builder)QueryRequest.builder(request).withUri(this.context.getLeader())).build());
    }

    @Override
    public CompletableFuture<CommitResponse> commit(CommitRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommitResponse.Builder)((CommitResponse.Builder)((CommitResponse.Builder)CommitResponse.builder().withUri(this.context.getLocalMember())).withStatus(Response.Status.ERROR)).withError(new IllegalStateException("Not the leader"))).build()));
        }
        return (CompletableFuture)this.commitHandler.apply(((CommitRequest.Builder)CommitRequest.builder(request).withUri(this.context.getLeader())).build());
    }

    private void cancelSyncTimer() {
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Cancelling sync timer", (Object)this.context.getLocalMember());
            this.currentTimer.cancel(false);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelSyncTimer);
    }

    @Override
    public String toString() {
        return String.format("%s[context=%s]", this.getClass().getSimpleName(), this.context);
    }
}

