/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.cluster.MessageHandler;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.raft.RaftConfig;
import net.kuujo.copycat.raft.RaftState;
import net.kuujo.copycat.raft.protocol.AppendRequest;
import net.kuujo.copycat.raft.protocol.AppendResponse;
import net.kuujo.copycat.raft.protocol.CommitRequest;
import net.kuujo.copycat.raft.protocol.CommitResponse;
import net.kuujo.copycat.raft.protocol.PollRequest;
import net.kuujo.copycat.raft.protocol.PollResponse;
import net.kuujo.copycat.raft.protocol.QueryRequest;
import net.kuujo.copycat.raft.protocol.QueryResponse;
import net.kuujo.copycat.raft.protocol.RaftProtocol;
import net.kuujo.copycat.raft.protocol.ReplicaInfo;
import net.kuujo.copycat.raft.protocol.Request;
import net.kuujo.copycat.raft.protocol.Response;
import net.kuujo.copycat.raft.protocol.SyncRequest;
import net.kuujo.copycat.raft.protocol.SyncResponse;
import net.kuujo.copycat.raft.protocol.VoteRequest;
import net.kuujo.copycat.raft.protocol.VoteResponse;
import net.kuujo.copycat.util.concurrent.Futures;
import net.kuujo.copycat.util.function.TriFunction;
import net.kuujo.copycat.util.internal.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftContext
extends Observable
implements RaftProtocol {
    private final Logger LOGGER = LoggerFactory.getLogger(RaftContext.class);
    private final ScheduledExecutorService executor;
    private Thread thread;
    private final RaftConfig config;
    private final LogManager log;
    private RaftState state;
    private TriFunction<Long, Long, ByteBuffer, ByteBuffer> consumer;
    private MessageHandler<SyncRequest, SyncResponse> syncHandler;
    private MessageHandler<PollRequest, PollResponse> pollHandler;
    private MessageHandler<VoteRequest, VoteResponse> voteHandler;
    private MessageHandler<AppendRequest, AppendResponse> appendHandler;
    private MessageHandler<QueryRequest, QueryResponse> queryHandler;
    private MessageHandler<CommitRequest, CommitResponse> commitHandler;
    private CompletableFuture<Void> openFuture;
    private final String localMember;
    private final Set<String> activeMembers;
    private Set<String> members;
    private final ReplicaInfo localMemberInfo;
    private final Map<String, ReplicaInfo> memberInfo = new HashMap<String, ReplicaInfo>();
    private boolean recovering = true;
    private String leader;
    private long term;
    private long version;
    private String lastVotedFor;
    private Long firstCommitIndex;
    private Long commitIndex;
    private Long lastApplied;
    private long electionTimeout = 500L;
    private long heartbeatInterval = 250L;
    private volatile boolean open;

    public RaftContext(String name, String uri, RaftConfig config, ScheduledExecutorService executor) {
        this.executor = executor;
        this.config = config;
        this.localMember = Assert.isNotNull(uri, "uri");
        this.activeMembers = new HashSet<String>(config.getReplicas());
        this.members = new HashSet<String>(config.getReplicas());
        this.members.add(uri);
        this.localMemberInfo = new ReplicaInfo(uri);
        this.memberInfo.put(uri, this.localMemberInfo);
        this.log = config.getLog().getLogManager(name);
        this.electionTimeout = config.getElectionTimeout();
        this.heartbeatInterval = config.getHeartbeatInterval();
        try {
            executor.submit(() -> {
                this.thread = Thread.currentThread();
                return this.thread;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CopycatException(e);
        }
    }

    public RaftConfig getConfig() {
        return this.config;
    }

    public Set<String> getActiveMembers() {
        return this.activeMembers;
    }

    public String getLocalMember() {
        return this.localMember;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public RaftContext setMembers(Collection<String> members) {
        this.members = new HashSet<String>(members);
        return this;
    }

    public RaftContext addMember(String member) {
        this.members.add(member);
        return this;
    }

    public RaftContext removeMember(String member) {
        this.members.remove(member);
        return this;
    }

    ReplicaInfo getLocalMemberInfo() {
        return this.localMemberInfo;
    }

    Collection<ReplicaInfo> getMemberInfo() {
        return this.memberInfo.values().stream().filter(info -> this.members.contains(info.getUri())).collect(Collectors.toList());
    }

    RaftContext setMemberInfo(Collection<ReplicaInfo> members) {
        Assert.isNotNull(members, "members");
        for (ReplicaInfo member : members) {
            ReplicaInfo record = this.memberInfo.get(member.getUri());
            if (record != null) {
                record.update(member);
                continue;
            }
            this.memberInfo.put(member.getUri(), member);
        }
        return this;
    }

    ReplicaInfo getMemberInfo(String uri) {
        return this.memberInfo.get(Assert.isNotNull(uri, "uri"));
    }

    RaftContext addMemberInfo(ReplicaInfo member) {
        ReplicaInfo record = this.memberInfo.get(member.getUri());
        if (record != null) {
            record.update(member);
        } else {
            this.memberInfo.put(member.getUri(), member);
        }
        return this;
    }

    RaftContext removeMemberInfo(ReplicaInfo member) {
        this.members.remove(member.getUri());
        return this;
    }

    RaftContext setLeader(String leader) {
        if (this.leader == null) {
            if (leader != null) {
                this.leader = leader;
                this.lastVotedFor = null;
                this.LOGGER.debug("{} - Found leader {}", (Object)this.localMember, (Object)leader);
                if (this.openFuture != null) {
                    this.openFuture.complete(null);
                    this.openFuture = null;
                }
                this.triggerChangeEvent();
            }
        } else if (leader != null) {
            if (!this.leader.equals(leader)) {
                this.leader = leader;
                this.lastVotedFor = null;
                this.LOGGER.debug("{} - Found leader {}", (Object)this.localMember, (Object)leader);
                this.triggerChangeEvent();
            }
        } else {
            this.leader = null;
            this.triggerChangeEvent();
        }
        return this;
    }

    public String getLeader() {
        return this.leader;
    }

    RaftContext setTerm(long term) {
        if (term > this.term) {
            this.term = term;
            this.leader = null;
            this.lastVotedFor = null;
            this.LOGGER.debug("{} - Incremented term {}", (Object)this.localMember, (Object)term);
            this.triggerChangeEvent();
        }
        return this;
    }

    public long getTerm() {
        return this.term;
    }

    RaftContext setVersion(long version) {
        this.version = Math.max(this.version, version);
        this.localMemberInfo.setVersion(this.version);
        return this;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isRecovering() {
        return this.recovering;
    }

    RaftContext setLastVotedFor(String candidate) {
        if (this.lastVotedFor != null && candidate != null) {
            throw new IllegalStateException("Already voted for another candidate");
        }
        if (this.leader != null && candidate != null) {
            throw new IllegalStateException("Cannot cast vote - leader already exists");
        }
        this.lastVotedFor = candidate;
        if (candidate != null) {
            this.LOGGER.debug("{} - Voted for {}", (Object)this.localMember, (Object)candidate);
        } else {
            this.LOGGER.debug("{} - Reset last voted for", (Object)this.localMember);
        }
        this.triggerChangeEvent();
        return this;
    }

    public String getLastVotedFor() {
        return this.lastVotedFor;
    }

    RaftContext setCommitIndex(Long commitIndex) {
        if (this.firstCommitIndex == null) {
            this.firstCommitIndex = commitIndex;
        }
        this.commitIndex = this.commitIndex != null ? Assert.arg(Assert.isNotNull(commitIndex, "commitIndex"), commitIndex >= this.commitIndex, "cannot decrease commit index", new Object[0]) : commitIndex;
        this.localMemberInfo.setIndex(this.commitIndex);
        return this;
    }

    public Long getCommitIndex() {
        return this.commitIndex;
    }

    RaftContext setLastApplied(Long lastApplied) {
        Long l = this.lastApplied != null ? Assert.arg(Assert.isNotNull(lastApplied, "lastApplied"), lastApplied >= this.lastApplied, "cannot decrease last applied index", new Object[0]) : (this.lastApplied = lastApplied);
        if (this.recovering && this.lastApplied != null && this.firstCommitIndex != null && this.lastApplied >= this.firstCommitIndex) {
            this.recovering = false;
        }
        return this;
    }

    public Long getLastApplied() {
        return this.lastApplied;
    }

    RaftContext setElectionTimeout(long electionTimeout) {
        this.electionTimeout = electionTimeout;
        return this;
    }

    public long getElectionTimeout() {
        return this.electionTimeout;
    }

    RaftContext setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public RaftContext consumer(TriFunction<Long, Long, ByteBuffer, ByteBuffer> consumer) {
        this.consumer = consumer;
        return this;
    }

    public TriFunction<Long, Long, ByteBuffer, ByteBuffer> consumer() {
        return this.consumer;
    }

    public LogManager log() {
        return this.log;
    }

    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        return this.wrapCall(request, this.state::sync);
    }

    @Override
    public RaftProtocol syncHandler(MessageHandler<SyncRequest, SyncResponse> handler) {
        this.syncHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        return this.wrapCall(request, this.state::poll);
    }

    @Override
    public RaftProtocol pollHandler(MessageHandler<PollRequest, PollResponse> handler) {
        this.pollHandler = handler;
        return this;
    }

    @Override
    public RaftContext voteHandler(MessageHandler<VoteRequest, VoteResponse> handler) {
        this.voteHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        return this.wrapCall(request, this.state::vote);
    }

    @Override
    public RaftContext appendHandler(MessageHandler<AppendRequest, AppendResponse> handler) {
        this.appendHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        return this.wrapCall(request, this.state::append);
    }

    @Override
    public RaftContext queryHandler(MessageHandler<QueryRequest, QueryResponse> handler) {
        this.queryHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        return this.wrapCall(request, this.state::query);
    }

    @Override
    public RaftContext commitHandler(MessageHandler<CommitRequest, CommitResponse> handler) {
        this.commitHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<CommitResponse> commit(CommitRequest request) {
        return this.wrapCall(request, this.state::commit);
    }

    private <T extends Request, U extends Response> CompletableFuture<U> wrapCall(T request, MessageHandler<T, U> handler) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> ((CompletableFuture)handler.apply(request)).whenComplete((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }));
        return future;
    }

    void checkThread() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("State not running on correct thread");
        }
    }

    CompletableFuture<RaftState.Type> transition(RaftState.Type state) {
        this.checkThread();
        if (this.state != null && state == this.state.type()) {
            return CompletableFuture.completedFuture(this.state.type());
        }
        this.LOGGER.info("{} - Transitioning to {}", (Object)this.localMember, (Object)state);
        if (this.state != null) {
            try {
                this.state.close().get();
                this.state = state.type().getConstructor(RaftContext.class).newInstance(this);
                this.registerHandlers(this.state);
                this.state.open().get();
            }
            catch (IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException | ExecutionException e) {
                throw new CopycatException(e);
            }
        }
        try {
            this.state = state.type().getConstructor(RaftContext.class).newInstance(this);
            this.registerHandlers(this.state);
            this.state.open().get();
        }
        catch (IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException | ExecutionException e) {
            throw new CopycatException(e);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void registerHandlers(RaftState state) {
        state.syncHandler(this.syncHandler);
        state.appendHandler((MessageHandler)this.appendHandler);
        state.pollHandler(this.pollHandler);
        state.voteHandler((MessageHandler)this.voteHandler);
        state.queryHandler(this.queryHandler);
        state.commitHandler((MessageHandler)this.commitHandler);
        state.transitionHandler(this::transition);
    }

    private void triggerChangeEvent() {
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    @Override
    public synchronized CompletableFuture<Void> open() {
        if (this.openFuture != null) {
            return this.openFuture;
        }
        this.openFuture = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                this.open = true;
                this.log.open();
                this.transition(this.activeMembers.contains(this.localMember) ? RaftState.Type.FOLLOWER : RaftState.Type.PASSIVE);
            }
            catch (Exception e) {
                this.openFuture.completeExceptionally(e);
                this.openFuture = null;
            }
        });
        return this.openFuture;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        if (this.openFuture != null) {
            this.openFuture.cancel(false);
            this.openFuture = null;
        } else if (!this.open) {
            return Futures.exceptionalFuture(new IllegalStateException("Context not open"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.execute(() -> this.transition(RaftState.Type.START).whenComplete((result, error) -> {
            if (error == null) {
                try {
                    this.log.close();
                    future.complete(null);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            } else {
                try {
                    this.log.close();
                    future.completeExceptionally((Throwable)error);
                }
                catch (Exception e) {
                    future.completeExceptionally((Throwable)error);
                }
            }
        }));
        return future;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }
}

