/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.cluster.MessageHandler;
import net.kuujo.copycat.raft.CandidateState;
import net.kuujo.copycat.raft.FollowerState;
import net.kuujo.copycat.raft.LeaderState;
import net.kuujo.copycat.raft.PassiveState;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.raft.StartState;
import net.kuujo.copycat.raft.protocol.AppendRequest;
import net.kuujo.copycat.raft.protocol.AppendResponse;
import net.kuujo.copycat.raft.protocol.CommitRequest;
import net.kuujo.copycat.raft.protocol.CommitResponse;
import net.kuujo.copycat.raft.protocol.PollRequest;
import net.kuujo.copycat.raft.protocol.PollResponse;
import net.kuujo.copycat.raft.protocol.QueryRequest;
import net.kuujo.copycat.raft.protocol.QueryResponse;
import net.kuujo.copycat.raft.protocol.RaftProtocol;
import net.kuujo.copycat.raft.protocol.Request;
import net.kuujo.copycat.raft.protocol.Response;
import net.kuujo.copycat.raft.protocol.SyncRequest;
import net.kuujo.copycat.raft.protocol.SyncResponse;
import net.kuujo.copycat.raft.protocol.VoteRequest;
import net.kuujo.copycat.raft.protocol.VoteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RaftState
implements RaftProtocol {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final RaftContext context;
    protected MessageHandler<SyncRequest, SyncResponse> syncHandler;
    protected MessageHandler<PollRequest, PollResponse> pollHandler;
    protected MessageHandler<VoteRequest, VoteResponse> voteHandler;
    protected MessageHandler<AppendRequest, AppendResponse> appendHandler;
    protected MessageHandler<CommitRequest, CommitResponse> commitHandler;
    protected MessageHandler<QueryRequest, QueryResponse> queryHandler;
    protected MessageHandler<Type, Type> transitionHandler;
    private volatile boolean open;

    protected RaftState(RaftContext context) {
        this.context = context;
    }

    protected <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public abstract Type type();

    protected final <R extends Request> R logRequest(R request) {
        this.LOGGER.debug("{} - Received {}", (Object)this.context.getLocalMember(), request);
        return request;
    }

    protected final <R extends Response> R logResponse(R response) {
        this.LOGGER.debug("{} - Sent {}", (Object)this.context.getLocalMember(), response);
        return response;
    }

    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        return this.exceptionalFuture(new IllegalStateException("Invalid Copycat state"));
    }

    @Override
    public RaftProtocol syncHandler(MessageHandler<SyncRequest, SyncResponse> handler) {
        this.syncHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        return this.exceptionalFuture(new IllegalStateException("Invalid Copycat state"));
    }

    @Override
    public RaftProtocol pollHandler(MessageHandler<PollRequest, PollResponse> handler) {
        this.pollHandler = handler;
        return this;
    }

    @Override
    public RaftState voteHandler(MessageHandler<VoteRequest, VoteResponse> handler) {
        this.voteHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        return this.exceptionalFuture(new IllegalStateException("Invalid Copycat state"));
    }

    @Override
    public RaftState appendHandler(MessageHandler<AppendRequest, AppendResponse> handler) {
        this.appendHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        return this.exceptionalFuture(new IllegalStateException("Invalid Copycat state"));
    }

    @Override
    public RaftProtocol queryHandler(MessageHandler<QueryRequest, QueryResponse> handler) {
        this.queryHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        return this.exceptionalFuture(new IllegalStateException("Invalid Copycat state"));
    }

    @Override
    public RaftState commitHandler(MessageHandler<CommitRequest, CommitResponse> handler) {
        this.commitHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<CommitResponse> commit(CommitRequest request) {
        return this.exceptionalFuture(new IllegalStateException("Invalid Copycat state"));
    }

    public RaftState transitionHandler(MessageHandler<Type, Type> handler) {
        this.transitionHandler = handler;
        return this;
    }

    @Override
    public CompletableFuture<Void> open() {
        this.context.checkThread();
        this.open = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public CompletableFuture<Void> close() {
        this.context.checkThread();
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return String.format("%s[context=%s]", this.getClass().getSimpleName(), this.context);
    }

    public static enum Type {
        START(StartState.class),
        PASSIVE(PassiveState.class),
        FOLLOWER(FollowerState.class),
        CANDIDATE(CandidateState.class),
        LEADER(LeaderState.class);

        private final Class<? extends RaftState> type;

        private Type(Class<? extends RaftState> type) {
            this.type = type;
        }

        public Class<? extends RaftState> type() {
            return this.type;
        }
    }
}

