/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractRequest;
import net.kuujo.copycat.util.internal.Assert;

public class AppendRequest
extends AbstractRequest {
    private long term;
    private String leader;
    private Long logIndex;
    private Long logTerm;
    private List<ByteBuffer> entries;
    private boolean firstIndex;
    private Long commitIndex;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AppendRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public String leader() {
        return this.leader;
    }

    public Long logIndex() {
        return this.logIndex;
    }

    public Long logTerm() {
        return this.logTerm;
    }

    public List<ByteBuffer> entries() {
        return this.entries;
    }

    public boolean firstIndex() {
        return this.firstIndex;
    }

    public Long commitIndex() {
        return this.commitIndex;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.term, this.leader, this.logIndex, this.logTerm, this.entries, this.firstIndex, this.commitIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof AppendRequest) {
            AppendRequest request = (AppendRequest)object;
            return request.member.equals(this.member) && request.term == this.term && request.leader.equals(this.leader) && request.logIndex.equals(this.logIndex) && request.logTerm.equals(this.logTerm) && request.entries.equals(this.entries) && request.firstIndex == this.firstIndex && request.commitIndex.equals(this.commitIndex);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[term=%d, leader=%s, logIndex=%d, logTerm=%d, entries=[%d], firstIndex=%b, commitIndex=%d]", this.getClass().getSimpleName(), this.term, this.leader, this.logIndex, this.logTerm, this.entries.size(), this.firstIndex, this.commitIndex);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, AppendRequest> {
        private Builder() {
            this(new AppendRequest());
        }

        private Builder(AppendRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((AppendRequest)this.request).term = Assert.arg(term, term > 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withLeader(String leader) {
            ((AppendRequest)this.request).leader = Assert.isNotNull(leader, "leader");
            return this;
        }

        public Builder withLogIndex(Long index) {
            ((AppendRequest)this.request).logIndex = Assert.index(index, index == null || index > 0L, "index must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withLogTerm(Long term) {
            ((AppendRequest)this.request).logTerm = Assert.arg(term, term == null || term > 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withEntries(ByteBuffer ... entries) {
            return this.withEntries(Arrays.asList(entries));
        }

        public Builder withEntries(List<ByteBuffer> entries) {
            ((AppendRequest)this.request).entries = Assert.isNotNull(entries, "entries");
            return this;
        }

        public Builder withFirstIndex(boolean firstIndex) {
            ((AppendRequest)this.request).firstIndex = firstIndex;
            return this;
        }

        public Builder withCommitIndex(Long index) {
            ((AppendRequest)this.request).commitIndex = Assert.index(index, index == null || index > 0L, "index must be greater than zero", new Object[0]);
            return this;
        }

        @Override
        public AppendRequest build() {
            super.build();
            Assert.isNotNull(((AppendRequest)this.request).leader, "leader");
            Assert.arg(((AppendRequest)this.request).term, ((AppendRequest)this.request).term > 0L, "term must be greater than zero", new Object[0]);
            Assert.index(((AppendRequest)this.request).logIndex, ((AppendRequest)this.request).logIndex == null || ((AppendRequest)this.request).logIndex > 0L, "index must be greater than zero", new Object[0]);
            Assert.arg(((AppendRequest)this.request).logTerm, ((AppendRequest)this.request).logTerm == null || ((AppendRequest)this.request).logTerm > 0L, "term must be greater than zero", new Object[0]);
            Assert.isNotNull(((AppendRequest)this.request).entries, "entries");
            Assert.index(((AppendRequest)this.request).commitIndex, ((AppendRequest)this.request).commitIndex == null || ((AppendRequest)this.request).commitIndex > 0L, "commit index must be greater than zero", new Object[0]);
            return (AppendRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((AppendRequest)((Builder)object).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

