/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.raft.protocol.AbstractRequest;
import net.kuujo.copycat.util.internal.Assert;

public class QueryRequest
extends AbstractRequest {
    private ByteBuffer entry;
    private Consistency consistency = Consistency.DEFAULT;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(QueryRequest request) {
        return new Builder(request);
    }

    public ByteBuffer entry() {
        return this.entry;
    }

    public Consistency consistency() {
        return this.consistency;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.member, this.entry, this.consistency});
    }

    public boolean equals(Object object) {
        if (object instanceof QueryRequest) {
            QueryRequest request = (QueryRequest)object;
            return request.member.equals(this.member) && request.entry.equals(this.entry) && request.consistency == this.consistency;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[entry=%s, consistency=%s]", new Object[]{this.getClass().getSimpleName(), this.entry.toString(), this.consistency});
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, QueryRequest> {
        private Builder() {
            this(new QueryRequest());
        }

        private Builder(QueryRequest request) {
            super(request);
        }

        public Builder withEntry(ByteBuffer entry) {
            ((QueryRequest)this.request).entry = Assert.isNotNull(entry, "entry");
            return this;
        }

        public Builder withConsistency(Consistency consistency) {
            ((QueryRequest)this.request).consistency = Assert.isNotNull(consistency, "consistency");
            return this;
        }

        @Override
        public QueryRequest build() {
            super.build();
            Assert.isNotNull(((QueryRequest)this.request).entry, "entry");
            return (QueryRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((QueryRequest)((Builder)object).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

