/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.resource.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.kuujo.copycat.Task;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.resource.Resource;
import net.kuujo.copycat.resource.ResourceState;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.util.serializer.Serializer;

public abstract class AbstractResource<T extends Resource<T>>
implements Resource<T> {
    private final List<Task<CompletableFuture<Void>>> startupTasks = Collections.synchronizedList(new ArrayList());
    private final List<Task<CompletableFuture<Void>>> shutdownTasks = Collections.synchronizedList(new ArrayList());
    protected final ResourceManager context;
    protected final Serializer serializer;
    protected final Executor executor;

    protected AbstractResource(ResourceManager context) {
        this.context = Assert.isNotNull(context, "context");
        this.serializer = context.config().getSerializer();
        this.executor = context.config().getExecutor() != null ? context.config().getExecutor() : Executors.newSingleThreadExecutor(new NamedThreadFactory("copycat-" + context.name() + "-%d"));
    }

    @Override
    public String name() {
        return this.context.name();
    }

    @Override
    public ResourceState state() {
        return this.context.state();
    }

    @Override
    public Cluster cluster() {
        return this.context.cluster();
    }

    @Override
    public T addStartupTask(Task<CompletableFuture<Void>> task) {
        this.startupTasks.add(task);
        return (T)this;
    }

    protected final CompletableFuture<Void> runStartupTasks() {
        return CompletableFuture.allOf((CompletableFuture[])this.startupTasks.stream().map(t -> (CompletableFuture)t.execute()).toArray(CompletableFuture[]::new));
    }

    @Override
    public T addShutdownTask(Task<CompletableFuture<Void>> task) {
        this.shutdownTasks.add(task);
        return (T)this;
    }

    protected final CompletableFuture<Void> runShutdownTasks() {
        return CompletableFuture.allOf((CompletableFuture[])this.shutdownTasks.stream().map(t -> (CompletableFuture)t.execute()).toArray(CompletableFuture[]::new));
    }

    @Override
    public boolean isOpen() {
        return this.context.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.context.isClosed();
    }
}

