/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatorConfig;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.Resource;
import net.kuujo.copycat.state.StateLogConfig;

public interface StateLog<T>
extends Resource<StateLog<T>> {
    public static <T> StateLog<T> create(String name) {
        return StateLog.create(name, new ClusterConfig(), new StateLogConfig());
    }

    public static <T> StateLog<T> create(String name, ClusterConfig cluster) {
        return StateLog.create(name, cluster, new StateLogConfig());
    }

    public static <T> StateLog<T> create(String name, ClusterConfig cluster, StateLogConfig config) {
        DefaultClusterCoordinator coordinator = new DefaultClusterCoordinator(new CoordinatorConfig().withName(name).withClusterConfig(cluster));
        return (StateLog)((StateLog)((StateLog)coordinator.getResource(name, config.resolve(cluster))).addStartupTask(() -> coordinator.open().thenApply(v -> null))).addShutdownTask(coordinator::close);
    }

    public <U extends T, V> StateLog<T> registerCommand(String var1, Function<U, V> var2);

    public StateLog<T> unregisterCommand(String var1);

    public <U extends T, V> StateLog<T> registerQuery(String var1, Function<U, V> var2);

    public <U extends T, V> StateLog<T> registerQuery(String var1, Function<U, V> var2, Consistency var3);

    public StateLog<T> unregisterQuery(String var1);

    public StateLog<T> unregister(String var1);

    public <V> StateLog<T> snapshotWith(Supplier<V> var1);

    public <V> StateLog<T> installWith(Consumer<V> var1);

    public <U> CompletableFuture<U> submit(String var1, T var2);
}

