/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceManager;
import net.kuujo.copycat.state.Command;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.Query;
import net.kuujo.copycat.state.StateContext;
import net.kuujo.copycat.state.StateLog;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateLog;
import net.kuujo.copycat.util.internal.Assert;

public class DefaultStateMachine<T>
extends AbstractResource<StateMachine<T>>
implements StateMachine<T> {
    private final Class<T> stateType;
    private T state;
    private final StateLog<List<Object>> log;
    private final InvocationHandler handler = new StateProxyInvocationHandler();
    private Map<String, Object> data = new HashMap<String, Object>(1024);
    private final Map<Class<?>, Method> initializers = new HashMap();
    private final Map<Method, String> methodCache = new ConcurrentHashMap<Method, String>();
    private final StateContext<T> context = new StateContext<T>(){

        @Override
        public Cluster cluster() {
            return DefaultStateMachine.this.cluster();
        }

        @Override
        public T state() {
            return DefaultStateMachine.this.state;
        }

        @Override
        public StateContext<T> put(String key, Object value) {
            DefaultStateMachine.this.data.put(key, value);
            return this;
        }

        @Override
        public <U> U get(String key) {
            return (U)DefaultStateMachine.this.data.get(key);
        }

        @Override
        public <U> U remove(String key) {
            return (U)DefaultStateMachine.this.data.remove(key);
        }

        @Override
        public StateContext<T> clear() {
            DefaultStateMachine.this.data.clear();
            return this;
        }

        @Override
        public StateContext<T> transition(T state) {
            DefaultStateMachine.this.state = state;
            DefaultStateMachine.this.initialize();
            return this;
        }
    };

    public DefaultStateMachine(ResourceManager context, Class<T> stateType, Class<? extends T> initialState) {
        super(context);
        this.stateType = Assert.isNotNull(stateType, "stateType");
        try {
            this.state = Assert.isNotNull(initialState, "initialState").newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.log = new DefaultStateLog<List<Object>>(context);
        this.registerCommands();
    }

    @Override
    public <U> U createProxy(Class<U> type) {
        return this.createProxy(type, this.getClass().getClassLoader());
    }

    @Override
    public <U> U createProxy(Class<U> type, ClassLoader classLoader) {
        return (U)Proxy.newProxyInstance(classLoader, new Class[]{type}, this.handler);
    }

    private Map<String, Object> snapshot() {
        HashMap<String, Object> snapshot = new HashMap<String, Object>(2);
        snapshot.put("state", this.state.getClass().getName());
        snapshot.put("data", this.data);
        return snapshot;
    }

    private void install(Map<String, Object> snapshot) {
        Object stateClassName = snapshot.get("state");
        if (stateClassName == null) {
            throw new IllegalStateException("Invalid snapshot");
        }
        try {
            Class<?> stateClass = Class.forName(stateClassName.toString());
            this.state = stateClass.newInstance();
            this.initialize();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Invalid snapshot state");
        }
        this.data = (Map)snapshot.get("data");
    }

    @Override
    public synchronized CompletableFuture<StateMachine<T>> open() {
        this.log.snapshotWith(this::snapshot);
        this.log.installWith(this::install);
        return ((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.log.open())).thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.log.isOpen();
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return ((CompletableFuture)this.log.close().whenComplete((result, error) -> {
            this.log.snapshotWith(null);
            this.log.installWith(null);
        })).thenComposeAsync(v -> this.runShutdownTasks(), this.executor);
    }

    @Override
    public boolean isClosed() {
        return this.log.isClosed();
    }

    private void registerCommands() {
        for (Method method : this.stateType.getMethods()) {
            Query query = method.getAnnotation(Query.class);
            if (query != null) {
                this.log.registerQuery(this.getOperationName(method), this.wrapOperation(method), query.consistency());
                continue;
            }
            Command command = method.getAnnotation(Command.class);
            if (command == null && !Modifier.isPublic(method.getModifiers())) continue;
            this.log.registerCommand(this.getOperationName(method), this.wrapOperation(method));
        }
        this.initialize();
    }

    private void initialize() {
        Method initializer = this.initializers.get(this.state.getClass());
        if (initializer == null) {
            for (Method method : this.state.getClass().getMethods()) {
                if (!method.isAnnotationPresent(Initializer.class)) continue;
                initializer = method;
                break;
            }
            if (initializer != null) {
                this.initializers.put(this.state.getClass(), initializer);
            }
        }
        if (initializer != null) {
            try {
                initializer.invoke(this.state, this.context);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String getOperationName(Method method) {
        return this.methodCache.computeIfAbsent(method, m -> m.getName() + '(' + String.join((CharSequence)",", Arrays.asList(m.getParameterTypes()).stream().map(Class::getCanonicalName).collect(Collectors.toList())) + ')');
    }

    private Function<List<Object>, Object> wrapOperation(Method method) {
        return values -> {
            try {
                return method.invoke(this.state, values.toArray(new Object[values.size()]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private class StateProxyInvocationHandler
    implements InvocationHandler {
        private StateProxyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> returnType = method.getReturnType();
            if (returnType == CompletableFuture.class) {
                return DefaultStateMachine.this.log.submit(DefaultStateMachine.this.getOperationName(method), new ArrayList<Object>(Arrays.asList(args != null ? args : new Object[]{})));
            }
            return DefaultStateMachine.this.log.submit(DefaultStateMachine.this.getOperationName(method), new ArrayList<Object>(Arrays.asList(args != null ? args : new Object[]{}))).get();
        }
    }
}

