/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.internal.Assert;

public abstract class AbstractConfigurable
implements Configurable {
    protected Config config;

    protected AbstractConfigurable() {
        this(new HashMap<String, Object>(128), new String[0]);
    }

    protected AbstractConfigurable(Map<String, Object> map, String ... resources) {
        Config config = ConfigFactory.parseMap(map);
        if (resources != null) {
            for (String resource : resources) {
                config = config.withFallback(ConfigFactory.load(resource));
            }
        }
        this.config = config.resolve();
    }

    protected AbstractConfigurable(String ... resources) {
        Assert.isNotNull(resources, "resources");
        Config config = null;
        for (String resource : resources) {
            config = config == null ? ConfigFactory.load(resource, ConfigParseOptions.defaults().setAllowMissing(true), ConfigResolveOptions.noSystem()) : config.withFallback(ConfigFactory.load(resource, ConfigParseOptions.defaults().setAllowMissing(true), ConfigResolveOptions.noSystem()));
            int index = resource.length();
            while ((index = resource.lastIndexOf(46, index - 1)) != -1) {
                config = config.withFallback(ConfigFactory.load(resource.substring(0, index), ConfigParseOptions.defaults().setAllowMissing(true), ConfigResolveOptions.noSystem()));
            }
        }
        this.config = config.resolve(ConfigResolveOptions.noSystem());
    }

    protected AbstractConfigurable(Configurable config) {
        this(config.toMap(), new String[0]);
    }

    protected static String[] addResources(String[] resources, String ... newResources) {
        ArrayList<String> results;
        ArrayList<String> arrayList = results = resources != null ? new ArrayList<String>(Arrays.asList(resources)) : new ArrayList(1);
        if (newResources != null) {
            results.addAll(Arrays.asList(newResources));
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public Configurable copy() {
        try {
            Configurable copy = (Configurable)this.getClass().newInstance();
            copy.configure(this.toMap());
            return copy;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to create configuration copy", new Object[]{e});
        }
    }

    @Override
    public void configure(Map<String, Object> config) {
        this.config = ConfigFactory.parseMap(config);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> config = new HashMap<String, Object>(this.config.root().unwrapped());
        config.put("class", this.getClass().getName());
        return config;
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            return this.config.equals(object);
        }
        if (object instanceof Configurable) {
            return ((Configurable)object).toMap().equals(this.config);
        }
        return false;
    }

    public int hashCode() {
        return 37 * this.config.hashCode();
    }

    public String toString() {
        return String.format("Config%s", this.config);
    }
}

