/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.Copyable;

public interface Configurable
extends Copyable<Configurable> {
    public static <T extends Configurable> T load(Map<String, Object> config) {
        String className = (String)config.get("class");
        if (className == null) {
            throw new ConfigurationException("Cannot load configuration. No configuration class specified", new Object[0]);
        }
        try {
            Configurable instance = (Configurable)Class.forName(className).newInstance();
            instance.configure(config);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Invalid configuration class", new Object[]{e});
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate configuration object", new Object[]{e});
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(Map.class);
            return (T)((Configurable)constructor.newInstance(config));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ConfigurationException("Invalid configuration class", new Object[]{e});
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ConfigurationException("Failed to instantiate configuration object", new Object[]{e});
        }
    }

    public void configure(Map<String, Object> var1);

    public Map<String, Object> toMap();
}

