/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.collections.DistributedMap;
import io.atomix.collections.DistributedMultiMap;
import io.atomix.collections.DistributedQueue;
import io.atomix.collections.DistributedSet;
import io.atomix.coordination.DistributedGroup;
import io.atomix.coordination.DistributedLock;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.ResourceManager;
import io.atomix.messaging.DistributedMessageBus;
import io.atomix.messaging.DistributedTaskQueue;
import io.atomix.messaging.DistributedTopic;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import io.atomix.variables.DistributedValue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public abstract class Atomix
implements ResourceManager<Atomix> {
    final ResourceClient client;

    protected Atomix(ResourceClient client) {
        this.client = Assert.notNull(client, "client");
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public Serializer serializer() {
        return this.client.client().serializer();
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key) {
        return this.get(key, DistributedMap.class);
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key, Resource.Options options) {
        return this.get(key, DistributedMap.class, options);
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key, Resource.Config config) {
        return this.get(key, DistributedMap.class, config);
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedMap.class, config, options);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key) {
        return this.get(key, DistributedMultiMap.class);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key, DistributedMultiMap.Config config) {
        return this.get(key, DistributedMultiMap.class, (Resource.Config)config);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key, Resource.Options options) {
        return this.get(key, DistributedMultiMap.class, options);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key, DistributedMultiMap.Config config, Resource.Options options) {
        return this.get(key, DistributedMultiMap.class, (Resource.Config)config, options);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key) {
        return this.get(key, DistributedSet.class);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key, Resource.Config config) {
        return this.get(key, DistributedSet.class, config);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key, Resource.Options options) {
        return this.get(key, DistributedSet.class, options);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedSet.class, config, options);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key) {
        return this.get(key, DistributedQueue.class);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key, Resource.Config config) {
        return this.get(key, DistributedQueue.class, config);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key, Resource.Options options) {
        return this.get(key, DistributedQueue.class, options);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedQueue.class, config, options);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key) {
        return this.get(key, DistributedValue.class);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key, Resource.Config config) {
        return this.get(key, DistributedValue.class, config);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key, Resource.Options options) {
        return this.get(key, DistributedValue.class, options);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedValue.class, config, options);
    }

    public CompletableFuture<DistributedLong> getLong(String key) {
        return this.get(key, DistributedLong.class);
    }

    public CompletableFuture<DistributedLong> getLong(String key, Resource.Config config) {
        return this.get(key, DistributedLong.class, config);
    }

    public CompletableFuture<DistributedLong> getLong(String key, Resource.Options options) {
        return this.get(key, DistributedLong.class, options);
    }

    public CompletableFuture<DistributedLong> getLong(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedLong.class, config, options);
    }

    public CompletableFuture<DistributedLock> getLock(String key) {
        return this.get(key, DistributedLock.class);
    }

    public CompletableFuture<DistributedLock> getLock(String key, Resource.Config config) {
        return this.get(key, DistributedLock.class, config);
    }

    public CompletableFuture<DistributedLock> getLock(String key, Resource.Options options) {
        return this.get(key, DistributedLock.class, options);
    }

    public CompletableFuture<DistributedLock> getLock(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedLock.class, config, options);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key) {
        return this.get(key, DistributedGroup.class);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key, Resource.Config config) {
        return this.get(key, DistributedGroup.class, config);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key, Resource.Options options) {
        return this.get(key, DistributedGroup.class, options);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedGroup.class, config, options);
    }

    public <T> CompletableFuture<DistributedTopic<T>> getTopic(String key) {
        return this.get(key, DistributedTopic.class);
    }

    public <T> CompletableFuture<DistributedTopic<T>> getTopic(String key, Resource.Config config) {
        return this.get(key, DistributedTopic.class, config);
    }

    public <T> CompletableFuture<DistributedTopic<T>> getTopic(String key, Resource.Options options) {
        return this.get(key, DistributedTopic.class, options);
    }

    public <T> CompletableFuture<DistributedTopic<T>> getTopic(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedTopic.class, config, options);
    }

    public <T> CompletableFuture<DistributedTaskQueue<T>> getTaskQueue(String key) {
        return this.get(key, DistributedTaskQueue.class);
    }

    public <T> CompletableFuture<DistributedTaskQueue<T>> getTaskQueue(String key, Resource.Config config) {
        return this.get(key, DistributedTaskQueue.class, config);
    }

    public <T> CompletableFuture<DistributedTaskQueue<T>> getTaskQueue(String key, Resource.Options options) {
        return this.get(key, DistributedTaskQueue.class, options);
    }

    public <T> CompletableFuture<DistributedTaskQueue<T>> getTaskQueue(String key, Resource.Config config, Resource.Options options) {
        return this.get(key, DistributedTaskQueue.class, config, options);
    }

    public CompletableFuture<DistributedMessageBus> getMessageBus(String key) {
        return this.get(key, DistributedMessageBus.class);
    }

    public CompletableFuture<DistributedMessageBus> getMessageBus(String key, Resource.Config config) {
        return this.get(key, DistributedMessageBus.class, config);
    }

    public CompletableFuture<DistributedMessageBus> getMessageBus(String key, DistributedMessageBus.Options options) {
        return this.get(key, DistributedMessageBus.class, (Resource.Options)options);
    }

    public CompletableFuture<DistributedMessageBus> getMessageBus(String key, Resource.Config config, DistributedMessageBus.Options options) {
        return this.get(key, DistributedMessageBus.class, config, (Resource.Options)options);
    }

    @Override
    public ResourceType type(Class<? extends Resource<?>> type) {
        return this.client.type(type);
    }

    @Override
    public CompletableFuture<Boolean> exists(String key) {
        return this.client.exists(key);
    }

    @Override
    public CompletableFuture<Set<String>> keys() {
        return this.client.keys().thenApply(this::cleanKeys);
    }

    @Override
    public <T extends Resource> CompletableFuture<Set<String>> keys(Class<? super T> type) {
        return this.client.keys(type).thenApply(this::cleanKeys);
    }

    @Override
    public CompletableFuture<Set<String>> keys(ResourceType type) {
        return this.client.keys(type).thenApply(this::cleanKeys);
    }

    private Set<String> cleanKeys(Set<String> keys) {
        keys.remove("");
        return keys;
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, null, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type, Resource.Config config) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, config, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, null, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type, Resource.Config config, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, config, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, null, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type, Resource.Config config) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, config, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, null, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type, Resource.Config config, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.get(key, type, config, options);
    }

    @Override
    public CompletableFuture<Atomix> open() {
        return this.client.open().thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

