/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.Atomix;
import io.atomix.ClientProperties;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.manager.ResourceClient;
import io.atomix.resource.ResourceTypeResolver;
import java.util.Collection;
import java.util.Properties;

public class AtomixClient
extends Atomix {
    public static Builder builder(String properties) {
        return AtomixClient.builder(PropertiesReader.load(properties).properties());
    }

    public static Builder builder(Properties properties) {
        ClientProperties clientProperties = new ClientProperties(properties);
        return AtomixClient.builder(clientProperties.replicas()).withTransport(clientProperties.transport()).withSerializer(clientProperties.serializer());
    }

    public static Builder builder(Address ... members) {
        return new Builder(ResourceClient.builder(members));
    }

    public static Builder builder(Collection<Address> members) {
        return new Builder(ResourceClient.builder(members));
    }

    private static ResourceClient buildClient(Properties properties) {
        ClientProperties clientProperties = new ClientProperties(properties);
        return ResourceClient.builder(clientProperties.replicas()).withTransport(clientProperties.transport()).build();
    }

    public AtomixClient(Properties properties) {
        this(AtomixClient.buildClient(properties));
    }

    public AtomixClient(ResourceClient client) {
        super(client);
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<AtomixClient> {
        private final ResourceClient.Builder builder;

        private Builder(ResourceClient.Builder builder) {
            this.builder = Assert.notNull(builder, "builder");
        }

        public Builder withTransport(Transport transport) {
            this.builder.withTransport(transport);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.builder.withSerializer(serializer);
            return this;
        }

        public Builder withResourceResolver(ResourceTypeResolver resolver) {
            this.builder.withResourceResolver(resolver);
            return this;
        }

        @Override
        public AtomixClient build() {
            return new AtomixClient(this.builder.build());
        }
    }
}

