/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.catalyst.util.QualifiedProperties;
import java.util.Collection;
import java.util.Properties;

abstract class AtomixProperties {
    public static final String SEED = "cluster.seed";
    public static final String SERIALIZER = "serializer";
    protected final PropertiesReader reader;

    protected AtomixProperties(Properties properties) {
        this.reader = new PropertiesReader(properties);
    }

    public Collection<Address> replicas() {
        return this.reader.getCollection(SEED, p -> this.parseAddress(this.reader.getString((String)p)));
    }

    protected Address parseAddress(String address) {
        String[] split = address.split(":");
        if (split.length != 2) {
            throw new ConfigurationException("malformed address: " + address, new Object[0]);
        }
        try {
            return new Address(split[0], Integer.valueOf(split[1]));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("invalid port number: " + split[1], new Object[0]);
        }
    }

    public Serializer serializer() {
        return new Serializer(new QualifiedProperties(this.reader.properties(), SERIALIZER));
    }
}

