/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.Atomix;
import io.atomix.Quorum;
import io.atomix.ReplicaProperties;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.LocalServerRegistry;
import io.atomix.catalyst.transport.LocalTransport;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.coordination.DistributedLock;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RetryStrategies;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.session.Session;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.ResourceManagerTypeResolver;
import io.atomix.manager.ResourceServer;
import io.atomix.manager.state.ResourceManagerState;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceTypeResolver;
import io.atomix.resource.ServiceLoaderResourceResolver;
import io.atomix.util.ClusterBalancer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class AtomixReplica
extends Atomix {
    private final ResourceServer server;
    private final ClusterBalancer balancer;
    private DistributedLock lock;
    private boolean locking;

    public static Builder builder(String properties) {
        return AtomixReplica.builder(PropertiesReader.load(properties).properties());
    }

    public static Builder builder(Properties properties) {
        ReplicaProperties replicaProperties = new ReplicaProperties(properties);
        Collection<Address> replicas = replicaProperties.replicas();
        return AtomixReplica.builder(replicaProperties.clientAddress(), replicaProperties.serverAddress(), replicas).withTransport(replicaProperties.transport()).withStorage(Storage.builder().withStorageLevel(replicaProperties.storageLevel()).withDirectory(replicaProperties.storageDirectory()).withMaxSegmentSize(replicaProperties.maxSegmentSize()).withMaxEntriesPerSegment(replicaProperties.maxEntriesPerSegment()).withMaxSnapshotSize(replicaProperties.maxSnapshotSize()).withRetainStaleSnapshots(replicaProperties.retainStaleSnapshots()).withCompactionThreads(replicaProperties.compactionThreads()).withMinorCompactionInterval(replicaProperties.minorCompactionInterval()).withMajorCompactionInterval(replicaProperties.majorCompactionInterval()).withCompactionThreshold(replicaProperties.compactionThreshold()).build()).withSerializer(replicaProperties.serializer()).withQuorumHint(replicaProperties.quorumHint() != -1 ? replicaProperties.quorumHint() : replicas.size()).withBackupCount(replicaProperties.backupCount()).withElectionTimeout(replicaProperties.electionTimeout()).withHeartbeatInterval(replicaProperties.heartbeatInterval()).withSessionTimeout(replicaProperties.sessionTimeout());
    }

    public static Builder builder(Address address, Address ... members) {
        return AtomixReplica.builder(address, address, Arrays.asList((Object[])Assert.notNull(members, "members")));
    }

    public static Builder builder(Address address, Collection<Address> members) {
        return new Builder(address, address, members);
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Address ... members) {
        return AtomixReplica.builder(clientAddress, serverAddress, Arrays.asList((Object[])Assert.notNull(members, "members")));
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Collection<Address> members) {
        return new Builder(clientAddress, serverAddress, members);
    }

    public AtomixReplica(Properties properties) {
        this(AtomixReplica.builder(properties));
    }

    private AtomixReplica(Builder builder) {
        this(builder.buildClient(), builder.buildServer(), builder.buildBalancer());
    }

    private AtomixReplica(ResourceClient client, ResourceServer server, ClusterBalancer balancer) {
        super(client);
        this.server = Assert.notNull(server, "server");
        this.balancer = Assert.notNull(balancer, "balancer");
    }

    private void registerListeners() {
        this.server.server().cluster().members().forEach(m -> {
            m.onTypeChange(t -> this.balance());
            m.onStatusChange(s -> this.balance());
        });
        this.server.server().cluster().onLeaderElection(l -> this.balance());
        this.server.server().cluster().onJoin(m -> {
            m.onTypeChange(t -> this.balance());
            m.onStatusChange(s -> this.balance());
            this.balance();
        });
        this.server.server().cluster().onLeave(m -> this.balance());
    }

    private void balance() {
        if (this.lock != null && !this.locking && this.server.server().cluster().member().equals(this.server.server().cluster().leader())) {
            this.locking = true;
            ((CompletableFuture)this.lock.lock().thenCompose(v -> this.balancer.balance(this.server.server().cluster()))).whenComplete((r1, e1) -> this.lock.unlock().whenComplete((r2, e2) -> {
                this.locking = false;
            }));
        }
    }

    @Override
    public CompletableFuture<Atomix> open() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.server.open().thenRun(this::registerListeners)).thenCompose(v -> super.open())).thenCompose(v -> this.client.get("", DistributedLock.class))).thenApply(lock -> {
            this.lock = lock;
            return this;
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)this.lock.lock().thenCompose(v -> this.balancer.replace(this.server.server().cluster()))).whenComplete((r1, e1) -> {
            this.balancer.close();
            this.lock.unlock().whenComplete((r2, e2) -> super.close().whenComplete((r3, e3) -> this.server.close().whenComplete((r4, e4) -> {
                if (e4 == null) {
                    future.complete(null);
                } else {
                    future.completeExceptionally((Throwable)e4);
                }
            })));
        });
        return future;
    }

    private static class CombinedServer
    implements Server {
        private final Server local;
        private final Server remote;

        private CombinedServer(Server local, Server remote) {
            this.local = local;
            this.remote = remote;
        }

        @Override
        public CompletableFuture<Void> listen(Address address, Consumer<Connection> listener) {
            Assert.notNull(address, "address");
            Assert.notNull(listener, "listener");
            return this.local.listen(address, listener).thenCompose(v -> this.remote.listen(address, listener));
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.local.close().thenCompose(v -> this.remote.close());
        }
    }

    private static class CombinedServerTransport
    implements Transport {
        private final Transport local;
        private final Transport remote;

        private CombinedServerTransport(Transport local, Transport remote) {
            this.local = local;
            this.remote = remote;
        }

        @Override
        public Client client() {
            return this.remote.client();
        }

        @Override
        public Server server() {
            return new CombinedServer(this.local.server(), this.remote.server());
        }
    }

    private static class CombinedClient
    implements Client {
        private final Address address;
        private final Client local;
        private final Client remote;

        private CombinedClient(Address address, Client local, Client remote) {
            this.address = address;
            this.local = local;
            this.remote = remote;
        }

        @Override
        public CompletableFuture<Connection> connect(Address address) {
            if (this.address.equals(address)) {
                return this.local.connect(address);
            }
            return this.remote.connect(address);
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.remote.close().thenRun(this.local::close);
        }
    }

    private static class CombinedClientTransport
    implements Transport {
        private final Address address;
        private final Transport local;
        private final Transport remote;

        private CombinedClientTransport(Address address, Transport local, Transport remote) {
            this.address = address;
            this.local = local;
            this.remote = remote;
        }

        @Override
        public Client client() {
            return new CombinedClient(this.address, this.local.client(), this.remote.client());
        }

        @Override
        public Server server() {
            return this.remote.server();
        }
    }

    private static class CombinedSelectionStrategy
    implements ServerSelectionStrategy {
        private final Address address;

        private CombinedSelectionStrategy(Address address) {
            this.address = address;
        }

        @Override
        public List<Address> selectConnections(Address leader, List<Address> servers) {
            ArrayList<Address> addresses = new ArrayList<Address>(servers.size());
            addresses.add(this.address);
            Collections.shuffle(servers);
            for (Address address : servers) {
                if (address.equals(this.address)) continue;
                addresses.add(address);
            }
            return addresses;
        }
    }

    private static final class CombinedCopycatClient
    implements CopycatClient {
        private final CopycatClient client;
        private final Transport transport;

        CombinedCopycatClient(CopycatClient client, Transport transport) {
            this.client = Assert.notNull(client, "client");
            this.transport = Assert.notNull(transport, "transport");
        }

        @Override
        public CopycatClient.State state() {
            return this.client.state();
        }

        @Override
        public Listener<CopycatClient.State> onStateChange(Consumer<CopycatClient.State> consumer) {
            return this.client.onStateChange(consumer);
        }

        @Override
        public ThreadContext context() {
            return this.client.context();
        }

        @Override
        public Transport transport() {
            return this.transport;
        }

        @Override
        public Serializer serializer() {
            return this.client.serializer();
        }

        @Override
        public Session session() {
            return this.client.session();
        }

        @Override
        public <T> CompletableFuture<T> submit(Command<T> command) {
            return this.client.submit(command);
        }

        @Override
        public <T> CompletableFuture<T> submit(Query<T> query) {
            return this.client.submit(query);
        }

        @Override
        public Listener<Void> onEvent(String event, Runnable callback) {
            return this.client.onEvent(event, callback);
        }

        @Override
        public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
            return this.client.onEvent(event, callback);
        }

        @Override
        public CompletableFuture<CopycatClient> open() {
            return this.client.open();
        }

        @Override
        public CompletableFuture<CopycatClient> recover() {
            return this.client.recover();
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.client.close();
        }

        @Override
        public boolean isOpen() {
            return this.client.isOpen();
        }

        @Override
        public boolean isClosed() {
            return this.client.isClosed();
        }

        public String toString() {
            return this.client.toString();
        }
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<AtomixReplica> {
        private final Address clientAddress;
        private final CopycatClient.Builder clientBuilder;
        private final CopycatServer.Builder serverBuilder;
        private Transport clientTransport;
        private Transport serverTransport;
        private final Collection<Address> members;
        private int quorumHint;
        private int backupCount;
        private LocalServerRegistry localRegistry = new LocalServerRegistry();
        private ResourceTypeResolver resourceResolver = new ServiceLoaderResourceResolver();
        private final ResourceRegistry registry = new ResourceRegistry();

        private Builder(Address clientAddress, Address serverAddress, Collection<Address> members) {
            this.members = Assert.notNull(members, "members");
            Serializer serializer = new Serializer();
            this.clientAddress = Assert.notNull(clientAddress, "clientAddress");
            this.clientBuilder = CopycatClient.builder(members).withSerializer(serializer.clone()).withServerSelectionStrategy(ServerSelectionStrategies.ANY).withConnectionStrategy(ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy(RecoveryStrategies.RECOVER).withRetryStrategy(RetryStrategies.FIBONACCI_BACKOFF);
            this.serverBuilder = CopycatServer.builder(clientAddress, serverAddress, members).withSerializer(serializer.clone());
        }

        public Builder withTransport(Transport transport) {
            this.serverTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withClientTransport(Transport transport) {
            this.clientTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withServerTransport(Transport transport) {
            this.serverTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.clientBuilder.withSerializer(serializer);
            this.serverBuilder.withSerializer(serializer);
            return this;
        }

        public Builder withQuorumHint(int quorumHint) {
            this.quorumHint = Assert.argNot(quorumHint, quorumHint < -1, "quorumHint must be positive, 0, or -1", new Object[0]);
            return this;
        }

        public Builder withQuorumHint(Quorum quorum) {
            this.quorumHint = Assert.notNull(quorum, "quorum").size();
            return this;
        }

        public Builder withBackupCount(int backupCount) {
            this.backupCount = Assert.argNot(backupCount, backupCount < 0, "backupCount must be positive", new Object[0]);
            return this;
        }

        public Builder withResourceResolver(ResourceTypeResolver resolver) {
            this.resourceResolver = Assert.notNull(resolver, "resolver");
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.serverBuilder.withStorage(storage);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            this.serverBuilder.withElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            this.serverBuilder.withHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.serverBuilder.withSessionTimeout(sessionTimeout);
            return this;
        }

        private void buildTransport() {
            if (this.serverTransport == null) {
                try {
                    this.serverTransport = (Transport)Class.forName("io.atomix.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
        }

        private ResourceClient buildClient() {
            this.buildTransport();
            this.resourceResolver.resolve(this.registry);
            this.clientBuilder.withTransport(new CombinedClientTransport(this.clientAddress, new LocalTransport(this.localRegistry), this.clientTransport != null ? this.clientTransport : this.serverTransport)).withServerSelectionStrategy(new CombinedSelectionStrategy(this.clientAddress));
            CopycatClient client = this.clientBuilder.build();
            client.serializer().resolve(new ResourceManagerTypeResolver(this.registry));
            return new ResourceClient(new CombinedCopycatClient(client, this.serverTransport), this.registry);
        }

        private ResourceServer buildServer() {
            if (this.clientTransport != null) {
                this.serverBuilder.withClientTransport(new CombinedServerTransport(new LocalTransport(this.localRegistry), this.clientTransport)).withServerTransport(this.serverTransport);
            } else {
                this.serverBuilder.withTransport(new CombinedServerTransport(new LocalTransport(this.localRegistry), this.serverTransport));
            }
            this.serverBuilder.withStateMachine(() -> new ResourceManagerState(this.registry));
            if (this.quorumHint == Quorum.ALL.size()) {
                this.serverBuilder.withType(Member.Type.ACTIVE);
            }
            CopycatServer server = this.serverBuilder.build();
            server.serializer().resolve(new ResourceManagerTypeResolver(this.registry));
            return new ResourceServer(server);
        }

        private ClusterBalancer buildBalancer() {
            return new ClusterBalancer(this.quorumHint == Quorum.SEED.size() ? this.members.size() : this.quorumHint, this.backupCount);
        }

        @Override
        public AtomixReplica build() {
            return new AtomixReplica(this.buildClient(), this.buildServer(), this.buildBalancer());
        }
    }
}

