/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.AtomixProperties;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.QualifiedProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

final class ClientProperties
extends AtomixProperties {
    public static final String TRANSPORT = "client.transport";
    private static final String DEFAULT_TRANSPORT = "io.atomix.catalyst.transport.NettyTransport";

    public ClientProperties(Properties properties) {
        super(properties);
    }

    public Transport transport() {
        String transportClass = this.reader.getString(TRANSPORT, DEFAULT_TRANSPORT);
        try {
            return (Transport)Class.forName(transportClass).getConstructor(Properties.class).newInstance(new QualifiedProperties(this.reader.properties(), TRANSPORT));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("unknown transport class: " + transportClass, new Object[]{e});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("failed to instantiate transport", new Object[]{e});
        }
    }
}

