/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferAllocator;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.buffer.InputStreamBufferInput;
import io.atomix.catalyst.buffer.OutputStreamBufferOutput;
import io.atomix.catalyst.buffer.UnpooledHeapAllocator;
import io.atomix.catalyst.serializer.Identifier;
import io.atomix.catalyst.serializer.JdkTypeResolver;
import io.atomix.catalyst.serializer.PrimitiveTypeResolver;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.serializer.SerializerProperties;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.TypeSerializerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class Serializer {
    private final SerializerRegistry registry;
    private final Map<Class<?>, TypeSerializer<?>> serializers = new HashMap();
    private final Map<Class<?>, Integer> ids = new HashMap();
    private final Map<String, Class<?>> types = new HashMap();
    private final BufferAllocator allocator;
    private final AtomicBoolean whitelistRequired;

    public Serializer() {
        this((BufferAllocator)new UnpooledHeapAllocator(), new PrimitiveTypeResolver(), new JdkTypeResolver());
    }

    public Serializer(BufferAllocator allocator) {
        this(allocator, new PrimitiveTypeResolver(), new JdkTypeResolver());
    }

    public Serializer(SerializableTypeResolver ... resolvers) {
        this((BufferAllocator)new UnpooledHeapAllocator(), resolvers);
    }

    public Serializer(Collection<SerializableTypeResolver> resolvers) {
        this((BufferAllocator)new UnpooledHeapAllocator(), resolvers);
    }

    public Serializer(BufferAllocator allocator, SerializableTypeResolver ... resolvers) {
        this(allocator, resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public Serializer(BufferAllocator allocator, Collection<SerializableTypeResolver> resolvers) {
        if (allocator == null) {
            throw new NullPointerException("allocator cannot be null");
        }
        this.allocator = allocator;
        this.whitelistRequired = new AtomicBoolean(true);
        this.registry = new SerializerRegistry(resolvers);
    }

    public Serializer(Properties properties) {
        this(new SerializerProperties(properties));
    }

    private Serializer(SerializerProperties properties) {
        this.allocator = properties.allocator();
        this.whitelistRequired = new AtomicBoolean(properties.whitelist());
        this.registry = new SerializerRegistry();
        Map<Integer, Class<?>> types = properties.types();
        Map<Integer, Class<?>> serializers = properties.serializers();
        Map<Integer, Class<?>> abstractSerializers = properties.abstractSerializers();
        Map<Integer, Class<?>> defaultSerializers = properties.defaultSerializers();
        for (Map.Entry<Integer, Class<?>> entry : defaultSerializers.entrySet()) {
            this.registry.registerDefault(types.get(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Integer, Class<?>> entry : types.entrySet()) {
            Class<?> serializer = serializers.get(entry.getKey());
            if (serializer != null) {
                this.registry.register(entry.getValue(), (int)entry.getKey(), serializer);
            }
            if ((serializer = abstractSerializers.get(entry.getKey())) != null) {
                this.registry.registerAbstract(entry.getValue(), (int)entry.getKey(), serializer);
                continue;
            }
            this.registry.register(entry.getValue(), entry.getKey());
        }
    }

    private Serializer(SerializerRegistry registry, BufferAllocator allocator, AtomicBoolean whitelistRequired) {
        this.registry = registry;
        this.allocator = allocator;
        this.whitelistRequired = whitelistRequired;
    }

    public Serializer enableWhitelist() {
        this.whitelistRequired.set(true);
        return this;
    }

    public Serializer disableWhitelist() {
        this.whitelistRequired.set(false);
        return this;
    }

    public Serializer withWhitelistRequired(boolean whitelistRequired) {
        this.whitelistRequired.set(whitelistRequired);
        return this;
    }

    public boolean isWhitelistRequired() {
        return this.whitelistRequired.get();
    }

    public SerializerRegistry registry() {
        return this.registry;
    }

    public Serializer resolve(SerializableTypeResolver ... resolvers) {
        this.registry.resolve(resolvers);
        return this;
    }

    public Serializer resolve(Collection<SerializableTypeResolver> resolvers) {
        this.registry.resolve(resolvers);
        return this;
    }

    public Serializer register(Class<?> type) {
        this.registry.register(type);
        return this;
    }

    public Serializer register(Class<?> type, int id) {
        this.registry.register(type, id);
        return this;
    }

    public Serializer register(Class<?> type, Class<? extends TypeSerializer> serializer) {
        this.registry.register(type, serializer);
        return this;
    }

    public Serializer register(Class<?> type, TypeSerializerFactory factory) {
        this.registry.register(type, factory);
        return this;
    }

    public Serializer register(Class<?> type, int id, Class<? extends TypeSerializer> serializer) {
        this.registry.register(type, id, serializer);
        return this;
    }

    public Serializer register(Class<?> type, int id, TypeSerializerFactory factory) {
        this.registry.register(type, id, factory);
        return this;
    }

    public Serializer registerAbstract(Class<?> abstractType, Class<? extends TypeSerializer> serializer) {
        this.registry.registerAbstract(abstractType, serializer);
        return this;
    }

    public Serializer registerAbstract(Class<?> abstractType, TypeSerializerFactory factory) {
        this.registry.registerAbstract(abstractType, factory);
        return this;
    }

    public Serializer registerAbstract(Class<?> abstractType, int id, Class<? extends TypeSerializer> serializer) {
        this.registry.registerAbstract(abstractType, id, serializer);
        return this;
    }

    public Serializer registerAbstract(Class<?> abstractType, int id, TypeSerializerFactory factory) {
        this.registry.registerAbstract(abstractType, id, factory);
        return this;
    }

    public Serializer registerDefault(Class<?> baseType, Class<? extends TypeSerializer> serializer) {
        this.registry.registerDefault(baseType, serializer);
        return this;
    }

    public Serializer registerDefault(Class<?> baseType, TypeSerializerFactory factory) {
        this.registry.registerDefault(baseType, factory);
        return this;
    }

    public BufferAllocator allocator() {
        return this.allocator;
    }

    public Buffer allocate() {
        return this.allocator.allocate();
    }

    public Buffer allocate(long capacity) {
        return this.allocator.allocate(capacity);
    }

    public Buffer allocate(long initialCapacity, long maxCapacity) {
        return this.allocator.allocate(initialCapacity, maxCapacity);
    }

    public <T> T copy(T object) {
        return this.readObject(this.writeObject(object).flip());
    }

    private <T> TypeSerializer<T> getSerializer(Class<T> type) {
        TypeSerializerFactory factory;
        TypeSerializer<?> serializer = this.serializers.get(type);
        if (serializer == null && (factory = this.registry.factory(type)) != null) {
            serializer = factory.createSerializer(type);
            this.serializers.put(type, serializer);
        }
        return serializer;
    }

    public <T> Buffer writeObject(T object) {
        return this.writeObject(object, this.allocator.allocate());
    }

    public <T> OutputStream writeObject(T object, OutputStream outputStream) {
        this.writeObject(object, new OutputStreamBufferOutput(outputStream));
        return outputStream;
    }

    public <T> Buffer writeObject(T object, Buffer buffer) {
        this.writeObject(object, (BufferOutput<?>)buffer);
        return buffer;
    }

    public <T> BufferOutput<?> writeObject(T object, BufferOutput<?> buffer) {
        int typeId;
        TypeSerializer<?> serializer;
        if (object == null) {
            return buffer.writeByte(Identifier.NULL.code());
        }
        Class<?> type = object.getClass();
        if (type.getEnclosingClass() != null && type.getEnclosingClass().isEnum()) {
            type = type.getEnclosingClass();
        }
        if ((serializer = this.getSerializer(type)) == null) {
            throw new SerializationException("cannot serialize unregistered type: " + type);
        }
        if (!this.ids.containsKey(type)) {
            this.ids.put(type, this.registry.id(type));
        }
        if ((typeId = this.registry.id(type)) == 0) {
            return this.writeByClass(type, object, buffer, serializer);
        }
        return this.writeById(typeId, object, buffer, serializer);
    }

    private BufferOutput writeById(int id, Object object, BufferOutput output, TypeSerializer serializer) {
        for (Identifier identifier : Identifier.values()) {
            if (!identifier.accept(id)) continue;
            identifier.write(id, (BufferOutput)output.writeByte(identifier.code()));
            serializer.write(object, output, this);
            return output;
        }
        throw new SerializationException("invalid type ID: " + id);
    }

    private BufferOutput writeByClass(Class<?> type, Object object, BufferOutput output, TypeSerializer serializer) {
        if (this.whitelistRequired.get()) {
            throw new SerializationException("cannot serialize unregistered type: " + type);
        }
        serializer.write(object, (BufferOutput)output.writeByte(Identifier.CLASS.code()).writeUTF8(type.getName()), this);
        return output;
    }

    public <T> T readObject(InputStream inputStream) {
        return this.readObject(new InputStreamBufferInput(inputStream));
    }

    public <T> T readObject(Buffer buffer) {
        return this.readObject((BufferInput<?>)buffer);
    }

    public <T> T readObject(BufferInput<?> buffer) {
        int code = buffer.readByte();
        Identifier identifier = Identifier.forCode(code);
        switch (identifier) {
            case NULL: {
                return null;
            }
            case CLASS: {
                return this.readByClass(buffer);
            }
        }
        return this.readById(identifier.read(buffer), buffer);
    }

    private <T> T readById(int id, BufferInput<?> buffer) {
        Class<?> type = this.registry.type(id);
        if (type == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        TypeSerializer<?> serializer = this.getSerializer(type);
        if (serializer == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        return (T)serializer.read(type, buffer, this);
    }

    private <T> T readByClass(BufferInput<?> buffer) {
        TypeSerializer<?> serializer;
        String name = buffer.readUTF8();
        if (this.whitelistRequired.get()) {
            throw new SerializationException("cannot deserialize unregistered type: " + name);
        }
        Class<?> type = this.types.get(name);
        if (type == null) {
            try {
                type = Class.forName(name);
                if (type == null) {
                    throw new SerializationException("cannot deserialize: unknown type");
                }
                this.types.put(name, type);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException("object class not found: " + name, e);
            }
        }
        if ((serializer = this.getSerializer(type)) == null) {
            throw new SerializationException("cannot deserialize unregistered type: " + name);
        }
        return (T)serializer.read(type, buffer, this);
    }

    public final Serializer clone() {
        return new Serializer(this.registry, this.allocator, this.whitelistRequired);
    }
}

