/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.util;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferObjectInput;
import io.atomix.catalyst.buffer.BufferObjectOutput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.io.Externalizable;
import java.io.IOException;

public class ExternalizableSerializer
implements TypeSerializer<Externalizable> {
    @Override
    public void write(Externalizable externalizable, BufferOutput buffer, Serializer serializer) {
        try {
            externalizable.writeExternal(new BufferObjectOutput(buffer, serializer));
        }
        catch (IOException e) {
            throw new SerializationException("failed to serialize externalizable type: " + externalizable.getClass(), e);
        }
    }

    @Override
    public Externalizable read(Class<Externalizable> type, BufferInput buffer, Serializer serializer) {
        try {
            Externalizable externalizable = type.newInstance();
            externalizable.readExternal(new BufferObjectInput(buffer, serializer));
            return externalizable;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SerializationException("failed to instantiate externalizable type: " + type, e);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializationException("failed to deserialize externalizable type: " + type, e);
        }
    }
}

