/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.util;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializableSerializer<T>
implements TypeSerializer<T> {
    @Override
    public void write(T object, BufferOutput buffer, Serializer serializer) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(os);){
            out.writeObject(object);
            out.flush();
            byte[] bytes = os.toByteArray();
            buffer.writeUnsignedShort(bytes.length).write(bytes);
        }
        catch (IOException e) {
            throw new SerializationException("failed to serialize Java object", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(Class<T> type, BufferInput buffer, Serializer serializer) {
        byte[] bytes = new byte[buffer.readUnsignedShort()];
        buffer.read(bytes);
        try {
            Throwable throwable = null;
            try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                Object object = in.readObject();
                return (T)object;
            }
            catch (ClassNotFoundException e) {
                try {
                    throw new SerializationException("failed to deserialize Java object", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException("failed to deserialize Java object", e);
        }
    }
}

