/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.LocalConnection;
import io.atomix.catalyst.transport.LocalServer;
import io.atomix.catalyst.transport.LocalServerRegistry;
import io.atomix.catalyst.transport.TransportException;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ComposableFuture;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class LocalClient
implements Client {
    private final UUID id = UUID.randomUUID();
    private final LocalServerRegistry registry;
    private final Set<LocalConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());

    public LocalClient(LocalServerRegistry registry) {
        this.registry = Assert.notNull(registry, "registry");
    }

    private ThreadContext getContext() {
        return ThreadContext.currentContextOrThrow();
    }

    @Override
    public CompletableFuture<Connection> connect(Address address) {
        Assert.notNull(address, "address");
        ThreadContext context = this.getContext();
        LocalServer server = this.registry.get(address);
        if (server == null) {
            return Futures.exceptionalFutureAsync(new TransportException("failed to connect"), context.executor());
        }
        LocalConnection connection = new LocalConnection(context, this.connections);
        this.connections.add(connection);
        CompletableFuture<Connection> future = new CompletableFuture<Connection>();
        server.connect(connection).whenCompleteAsync((result, error) -> {
            if (error == null) {
                future.complete(connection);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, context.executor());
        return future;
    }

    @Override
    public CompletableFuture<Void> close() {
        ComposableFuture<Void> future = new ComposableFuture<Void>();
        ThreadContext context = this.getContext();
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (LocalConnection connection : this.connections) {
            futures[i++] = connection.close();
        }
        CompletableFuture.allOf(futures).whenCompleteAsync(future, context.executor());
        return future;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof LocalClient && ((LocalClient)object).id.equals(this.id);
    }
}

