/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.LocalConnection;
import io.atomix.catalyst.transport.LocalServerRegistry;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class LocalServer
implements Server {
    private final UUID id = UUID.randomUUID();
    private final LocalServerRegistry registry;
    private final Set<LocalConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Address address;
    private volatile ListenerHolder listener;

    public LocalServer(LocalServerRegistry registry) {
        this.registry = Assert.notNull(registry, "registry");
    }

    CompletableFuture<Void> connect(LocalConnection connection) {
        LocalConnection localConnection = new LocalConnection(this.listener.context, this.connections);
        this.connections.add(localConnection);
        connection.connect(localConnection);
        localConnection.connect(connection);
        return CompletableFuture.runAsync(() -> this.listener.listener.accept(localConnection), this.listener.context.executor());
    }

    @Override
    public synchronized CompletableFuture<Void> listen(Address address, Consumer<Connection> listener) {
        Assert.notNull(address, "address");
        Assert.notNull(listener, "listener");
        if (this.address != null) {
            if (!this.address.equals(address)) {
                throw new IllegalStateException(String.format("already listening at %s", this.address));
            }
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.registry.register(address, this);
        ThreadContext context = ThreadContext.currentContextOrThrow();
        this.address = address;
        this.listener = new ListenerHolder(listener, context);
        context.execute(() -> future.complete(null));
        return future;
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        if (this.address == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.registry.unregister(this.address);
        this.address = null;
        this.listener = null;
        ThreadContext context = ThreadContext.currentContextOrThrow();
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (LocalConnection connection : this.connections) {
            futures[i++] = connection.close();
        }
        CompletableFuture.allOf(futures).thenRunAsync(() -> future.complete(null), context.executor());
        return future;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof LocalServer && ((LocalServer)object).id.equals(this.id);
    }

    private static class ListenerHolder {
        private final Consumer<Connection> listener;
        private final ThreadContext context;

        private ListenerHolder(Consumer<Connection> listener, ThreadContext context) {
            this.listener = listener;
            this.context = context;
        }
    }
}

