/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.util;

import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class Listeners<T>
implements Iterable<Listener<T>> {
    private final List<ListenerHolder> listeners = new CopyOnWriteArrayList<ListenerHolder>();

    public int size() {
        return this.listeners.size();
    }

    public Listener<T> add(Consumer<T> listener) {
        Assert.notNull(listener, "listener");
        ListenerHolder holder = new ListenerHolder(listener, ThreadContext.currentContext());
        this.listeners.add(holder);
        return holder;
    }

    public CompletableFuture<Void> accept(T event) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(this.listeners.size());
        for (ListenerHolder listener : this.listeners) {
            if (listener.context != null) {
                futures.add(listener.context.execute(() -> listener.listener.accept(event)));
                continue;
            }
            listener.listener.accept(event);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    @Override
    public Iterator<Listener<T>> iterator() {
        return this.listeners.iterator();
    }

    private class ListenerHolder
    implements Listener<T> {
        private final Consumer<T> listener;
        private final ThreadContext context;

        private ListenerHolder(Consumer<T> listener, ThreadContext context) {
            this.listener = listener;
            this.context = context;
        }

        @Override
        public void accept(T event) {
            if (this.context != null) {
                this.context.executor().execute(() -> this.listener.accept(event));
            } else {
                this.listener.accept(event);
            }
        }

        @Override
        public void close() {
            Listeners.this.listeners.remove(this);
        }
    }
}

