/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.util.concurrent;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.CatalystThread;
import io.atomix.catalyst.util.concurrent.Scheduled;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;

public interface ThreadContext
extends AutoCloseable {
    public static ThreadContext currentContext() {
        Thread thread = Thread.currentThread();
        return thread instanceof CatalystThread ? ((CatalystThread)thread).getContext() : null;
    }

    public static ThreadContext currentContextOrThrow() {
        ThreadContext context = ThreadContext.currentContext();
        Assert.state(context != null, "not on a Catalyst thread", new Object[0]);
        return context;
    }

    default public void checkThread() {
        Assert.state(ThreadContext.currentContext() == this, "not on a Catalyst thread", new Object[0]);
    }

    public Logger logger();

    public Serializer serializer();

    public Executor executor();

    default public CompletableFuture<Void> execute(Runnable callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor().execute(() -> {
            try {
                callback.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    default public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        CompletableFuture future = new CompletableFuture();
        this.executor().execute(() -> {
            try {
                future.complete(callback.get());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public Scheduled schedule(Duration var1, Runnable var2);

    public Scheduled schedule(Duration var1, Duration var2, Runnable var3);

    @Override
    public void close();
}

