/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.MapCommands;
import io.atomix.collections.state.MapState;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-11, stateMachine=MapState.class, typeResolver=MapCommands.TypeResolver.class)
public class DistributedMap<K, V>
extends Resource<DistributedMap<K, V>> {
    public static Resource.Options options() {
        return new Resource.Options();
    }

    public static Resource.Config config() {
        return new Resource.Config();
    }

    public DistributedMap(CopycatClient client) {
        this(client, new Resource.Options());
    }

    public DistributedMap(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new MapCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.submit(new MapCommands.IsEmpty(), consistency);
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new MapCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.submit(new MapCommands.Size(), consistency);
    }

    public CompletableFuture<Boolean> containsKey(Object key) {
        return this.submit(new MapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsKey(Object key, ReadConsistency consistency) {
        return this.submit(new MapCommands.ContainsKey(key), consistency);
    }

    public CompletableFuture<Boolean> containsValue(Object value) {
        return this.submit(new MapCommands.ContainsValue(value));
    }

    public CompletableFuture<Boolean> containsValue(Object value, ReadConsistency consistency) {
        return this.submit(new MapCommands.ContainsValue(value), consistency);
    }

    public CompletableFuture<V> get(Object key) {
        return this.submit(new MapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<V> get(Object key, ReadConsistency consistency) {
        return this.submit(new MapCommands.Get(key), consistency).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue) {
        return this.submit(new MapCommands.GetOrDefault(key, defaultValue)).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue, ReadConsistency consistency) {
        return this.submit(new MapCommands.GetOrDefault(key, defaultValue), consistency).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value) {
        return this.submit(new MapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value, Duration ttl) {
        return this.submit(new MapCommands.Put(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.submit(new MapCommands.PutIfAbsent(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value, Duration ttl) {
        return this.submit(new MapCommands.PutIfAbsent(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> remove(Object key) {
        return this.submit(new MapCommands.Remove(key)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.submit(new MapCommands.RemoveIfPresent(key, value));
    }

    public CompletableFuture<V> replace(K key, V value) {
        return this.submit(new MapCommands.Replace(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> replace(K key, V value, Duration ttl) {
        return this.submit(new MapCommands.Replace(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.submit(new MapCommands.ReplaceIfPresent(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue, Duration ttl) {
        return this.submit(new MapCommands.ReplaceIfPresent(key, oldValue, newValue, ttl.toMillis()));
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.submit(new MapCommands.KeySet()).thenApply(keys -> keys);
    }

    public CompletableFuture<Collection<V>> values() {
        return this.submit(new MapCommands.Values()).thenApply(values -> values);
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.submit(new MapCommands.EntrySet()).thenApply(entries -> entries);
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new MapCommands.Clear());
    }
}

