/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.MultiMapCommands;
import io.atomix.collections.state.MultiMapState;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-12, stateMachine=MultiMapState.class, typeResolver=MultiMapCommands.TypeResolver.class)
public class DistributedMultiMap<K, V>
extends Resource<DistributedMultiMap<K, V>> {
    public static Resource.Options options() {
        return new Resource.Options();
    }

    public static Config config() {
        return new Config();
    }

    public DistributedMultiMap(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new MultiMapCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.IsEmpty(), consistency);
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new MultiMapCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.Size(), consistency);
    }

    public CompletableFuture<Integer> size(K key) {
        return this.submit(new MultiMapCommands.Size(key));
    }

    public CompletableFuture<Integer> size(K key, ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.Size(key), consistency);
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.submit(new MultiMapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsKey(K key, ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.ContainsKey(key), consistency);
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.submit(new MultiMapCommands.ContainsEntry(key, value));
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value, ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.ContainsEntry(key, value), consistency);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.submit(new MultiMapCommands.ContainsValue(value));
    }

    public CompletableFuture<Boolean> containsValue(V value, ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.ContainsValue(value), consistency);
    }

    public CompletableFuture<Collection<V>> get(K key) {
        return this.submit(new MultiMapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<Collection<V>> get(K key, ReadConsistency consistency) {
        return this.submit(new MultiMapCommands.Get(key), consistency).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return this.submit(new MultiMapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> put(K key, V value, Duration ttl) {
        return this.submit(new MultiMapCommands.Put(key, value, ttl.toMillis()));
    }

    public CompletableFuture<Collection<V>> remove(Object key) {
        return this.submit(new MultiMapCommands.Remove(key)).thenApply(result -> (Collection)result);
    }

    public CompletableFuture<Boolean> remove(Object key, Object value) {
        return this.submit(new MultiMapCommands.Remove(key, value)).thenApply(result -> (boolean)((Boolean)result));
    }

    public CompletableFuture<Void> removeValue(Object value) {
        return this.submit(new MultiMapCommands.RemoveValue(value));
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new MultiMapCommands.Clear());
    }

    public static enum Order {
        NATURAL,
        INSERT,
        NONE;

    }

    public static class Config
    extends Resource.Config {
        public Config withValueOrder(Order order) {
            this.setProperty("order", order.name().toLowerCase());
            return this;
        }

        public Order getValueOrder() {
            return Order.valueOf(this.getProperty("order", Order.INSERT.name().toLowerCase()).toUpperCase());
        }
    }
}

