/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.QueueCommands;
import io.atomix.collections.state.QueueState;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-14, stateMachine=QueueState.class, typeResolver=QueueCommands.TypeResolver.class)
public class DistributedQueue<T>
extends Resource<DistributedQueue<T>> {
    public static Resource.Options options() {
        return new Resource.Options();
    }

    public static Resource.Config config() {
        return new Resource.Config();
    }

    public DistributedQueue(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.submit(new QueueCommands.Add(value));
    }

    public CompletableFuture<Boolean> offer(T value) {
        return this.submit(new QueueCommands.Offer(value));
    }

    public CompletableFuture<T> peek() {
        return this.submit(new QueueCommands.Peek()).thenApply(v -> v);
    }

    public CompletableFuture<T> poll() {
        return this.submit(new QueueCommands.Poll()).thenApply(v -> v);
    }

    public CompletableFuture<T> element() {
        return this.submit(new QueueCommands.Element()).thenApply(v -> v);
    }

    public CompletableFuture<T> remove() {
        return this.submit(new QueueCommands.Remove()).thenApply(v -> v);
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.submit(new QueueCommands.Remove(value)).thenApply(v -> (boolean)((Boolean)v));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.submit(new QueueCommands.Contains(value));
    }

    public CompletableFuture<Boolean> contains(Object value, ReadConsistency consistency) {
        return this.submit(new QueueCommands.Contains(value), consistency);
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new QueueCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.submit(new QueueCommands.Size(), consistency);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new QueueCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.submit(new QueueCommands.IsEmpty(), consistency);
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new QueueCommands.Clear());
    }
}

