/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.state.SetCommands;
import io.atomix.collections.state.SetState;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-13, stateMachine=SetState.class, typeResolver=SetCommands.TypeResolver.class)
public class DistributedSet<T>
extends Resource<DistributedSet<T>> {
    public static Resource.Options options() {
        return new Resource.Options();
    }

    public static Resource.Config config() {
        return new Resource.Config();
    }

    public DistributedSet(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.submit(new SetCommands.Add(value));
    }

    public CompletableFuture<Boolean> add(T value, Duration ttl) {
        return this.submit(new SetCommands.Add(value, ttl.toMillis()));
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.submit(new SetCommands.Remove(value));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.submit(new SetCommands.Contains(value));
    }

    public CompletableFuture<Boolean> contains(Object value, ReadConsistency consistency) {
        return this.submit(new SetCommands.Contains(value), consistency);
    }

    public CompletableFuture<Integer> size() {
        return this.submit(new SetCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.submit(new SetCommands.Size(), consistency);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.submit(new SetCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.submit(new SetCommands.IsEmpty(), consistency);
    }

    public CompletableFuture<Void> clear() {
        return this.submit(new SetCommands.Clear());
    }
}

