/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.collections.DistributedMap;
import io.atomix.collections.state.MapCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapState
extends ResourceStateMachine {
    private final Map<Object, Value> map = new HashMap<Object, Value>();

    public MapState() {
        super(new ResourceType(DistributedMap.class));
    }

    public boolean containsKey(Commit<MapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.map.containsKey(commit.operation().key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Commit<MapCommands.ContainsValue> commit) {
        try {
            for (Value value : this.map.values()) {
                if (!((MapCommands.TtlCommand)value.commit.operation()).value().equals(commit.operation().value())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Commit<MapCommands.Get> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            Object object = value != null ? ((MapCommands.TtlCommand)value.commit.operation()).value() : null;
            return object;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOrDefault(Commit<MapCommands.GetOrDefault> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            Object object = value != null ? ((MapCommands.TtlCommand)value.commit.operation()).value() : commit.operation().defaultValue();
            return object;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Commit<MapCommands.Put> commit) {
        Scheduled timer = commit.operation().ttl() > 0L ? this.executor.schedule(Duration.ofMillis(commit.operation().ttl()), () -> this.map.remove(((MapCommands.Put)commit.operation()).key()).commit.close()) : null;
        Value value = this.map.put(commit.operation().key(), new Value(commit, timer));
        if (value == null) return null;
        try {
            if (value.timer != null) {
                value.timer.cancel();
            }
            Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
            value.commit.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                value.commit.close();
                throw throwable;
            }
            catch (Exception e) {
                commit.close();
                throw e;
            }
        }
    }

    public Object putIfAbsent(Commit<MapCommands.PutIfAbsent> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            if (value == null) {
                Scheduled timer = commit.operation().ttl() > 0L ? this.executor.schedule(Duration.ofMillis(commit.operation().ttl()), () -> this.map.remove(((MapCommands.PutIfAbsent)commit.operation()).key()).commit.close()) : null;
                this.map.put(commit.operation().key(), new Value(commit, timer));
                return null;
            }
            commit.close();
            return ((MapCommands.TtlCommand)value.commit.operation()).value();
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Commit<MapCommands.Remove> commit) {
        try {
            Value value = this.map.remove(commit.operation().key());
            if (value != null) {
                try {
                    if (value.timer != null) {
                        value.timer.cancel();
                    }
                    Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                    return object;
                }
                finally {
                    value.commit.close();
                }
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIfPresent(Commit<MapCommands.RemoveIfPresent> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            if (value == null || ((MapCommands.TtlCommand)value.commit.operation()).value() == null && commit.operation().value() != null || ((MapCommands.TtlCommand)value.commit.operation()).value() != null && !((MapCommands.TtlCommand)value.commit.operation()).value().equals(commit.operation().value())) {
                boolean bl = false;
                return bl;
            }
            try {
                this.map.remove(commit.operation().key());
                if (value.timer != null) {
                    value.timer.cancel();
                }
                boolean bl = true;
                value.commit.close();
                return bl;
            }
            catch (Throwable throwable) {
                value.commit.close();
                throw throwable;
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object replace(Commit<MapCommands.Replace> commit) {
        Value value = this.map.get(commit.operation().key());
        if (value != null) {
            try {
                if (value.timer != null) {
                    value.timer.cancel();
                }
                Scheduled timer = commit.operation().ttl() > 0L ? this.executor.schedule(Duration.ofMillis(commit.operation().ttl()), () -> {
                    this.map.remove(((MapCommands.Replace)commit.operation()).key());
                    commit.close();
                }) : null;
                this.map.put(commit.operation().key(), new Value(commit, timer));
                Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                return object;
            }
            finally {
                value.commit.close();
            }
        }
        commit.close();
        return null;
    }

    public boolean replaceIfPresent(Commit<MapCommands.ReplaceIfPresent> commit) {
        Value value = this.map.get(commit.operation().key());
        if (value == null) {
            commit.close();
            return false;
        }
        if (((MapCommands.TtlCommand)value.commit.operation()).value() == null && commit.operation().replace() == null || ((MapCommands.TtlCommand)value.commit.operation()).value() != null && ((MapCommands.TtlCommand)value.commit.operation()).value().equals(commit.operation().replace())) {
            if (value.timer != null) {
                value.timer.cancel();
            }
            Scheduled timer = commit.operation().ttl() > 0L ? this.executor.schedule(Duration.ofMillis(commit.operation().ttl()), () -> this.map.remove(((MapCommands.ReplaceIfPresent)commit.operation()).key()).commit.close()) : null;
            this.map.put(commit.operation().key(), new Value(commit, timer));
            value.commit.close();
            return true;
        }
        commit.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values(Commit<MapCommands.Values> commit) {
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Value value : this.map.values()) {
                values.add(((MapCommands.TtlCommand)value.commit.operation()).value());
            }
            ArrayList<Object> arrayList = values;
            return arrayList;
        }
        finally {
            commit.close();
        }
    }

    public Set<Object> keySet(Commit<MapCommands.KeySet> commit) {
        try {
            HashSet<Object> hashSet = new HashSet<Object>(this.map.keySet());
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<Object, Object>> entrySet(Commit<MapCommands.EntrySet> commit) {
        try {
            HashSet<MapEntry> entries = new HashSet<MapEntry>();
            for (Map.Entry<Object, Value> entry : this.map.entrySet()) {
                entries.add(new MapEntry(entry.getKey(), ((MapCommands.TtlCommand)entry.getValue().commit.operation()).value()));
            }
            HashSet<MapEntry> hashSet = entries;
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    public int size(Commit<MapCommands.Size> commit) {
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    public boolean isEmpty(Commit<MapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map == null || this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    public void clear(Commit<MapCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    @Override
    public void delete() {
        Iterator<Map.Entry<Object, Value>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Value> entry = iterator.next();
            Value value = entry.getValue();
            if (value.timer != null) {
                value.timer.cancel();
            }
            value.commit.close();
            iterator.remove();
        }
    }

    private static class MapEntry
    implements Map.Entry<Object, Object> {
        private final Object key;
        private Object value;

        private MapEntry(Object key, Object value) {
            this.key = Assert.notNull(key, "key");
            this.value = value;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }

    private static class Value {
        private final Commit<? extends MapCommands.TtlCommand> commit;
        private final Scheduled timer;

        private Value(Commit<? extends MapCommands.TtlCommand> commit, Scheduled timer) {
            this.commit = commit;
            this.timer = timer;
        }
    }
}

