/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Collection;

public class MultiMapCommands {
    private MultiMapCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(ContainsKey.class, -80);
            registry.register(ContainsEntry.class, -81);
            registry.register(ContainsValue.class, -82);
            registry.register(Put.class, -83);
            registry.register(Get.class, -84);
            registry.register(Remove.class, -85);
            registry.register(RemoveValue.class, -86);
            registry.register(IsEmpty.class, -87);
            registry.register(Size.class, -88);
            registry.register(Clear.class, -89);
        }
    }

    public static class Clear
    extends MultiMapCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Size
    extends KeyQuery<Integer> {
        public Size() {
        }

        public Size(Object key) {
            super(key);
        }
    }

    public static class IsEmpty
    extends MultiMapQuery<Boolean> {
    }

    public static class RemoveValue
    extends MultiMapCommand<Void> {
        private Object value;

        public RemoveValue() {
        }

        public RemoveValue(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }
    }

    public static class Remove
    extends EntryCommand<Object> {
        public Remove() {
        }

        public Remove(Object key) {
            super(key);
        }

        public Remove(Object key, Object value) {
            super(key, value);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Get
    extends KeyQuery<Collection> {
        public Get() {
        }

        public Get(Object key) {
            super(key);
        }
    }

    public static class Put
    extends TtlCommand<Boolean> {
        public Put() {
        }

        public Put(Object key, Object value) {
            super(key, value, 0L);
        }

        public Put(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    public static abstract class TtlCommand<V>
    extends EntryCommand<V> {
        protected long ttl;

        public TtlCommand() {
        }

        public TtlCommand(Object key, Object value, long ttl) {
            super(key, value);
            this.ttl = ttl;
        }

        @Override
        public Command.CompactionMode compaction() {
            return this.ttl > 0L ? Command.CompactionMode.SEQUENTIAL : Command.CompactionMode.QUORUM;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.ttl = buffer.readLong();
        }
    }

    public static abstract class EntryCommand<V>
    extends KeyCommand<V> {
        protected Object value;

        protected EntryCommand() {
        }

        protected EntryCommand(Object key) {
            super(key);
        }

        protected EntryCommand(Object key, Object value) {
            super(key);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static class ContainsValue
    extends ValueQuery<Boolean> {
        public ContainsValue() {
        }

        public ContainsValue(Object value) {
            super(value);
        }
    }

    public static class ContainsEntry
    extends EntryQuery<Boolean> {
        public ContainsEntry() {
        }

        public ContainsEntry(Object key, Object value) {
            super(key, value);
        }
    }

    public static class ContainsKey
    extends KeyQuery<Boolean> {
        public ContainsKey() {
        }

        public ContainsKey(Object key) {
            super(key);
        }
    }

    public static class EntryQuery<V>
    extends KeyQuery<V> {
        protected Object value;

        protected EntryQuery() {
        }

        protected EntryQuery(Object key, Object value) {
            super(key);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static abstract class ValueQuery<V>
    extends MultiMapQuery<V> {
        protected Object value;

        protected ValueQuery() {
        }

        protected ValueQuery(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static abstract class KeyQuery<V>
    extends MultiMapQuery<V> {
        protected Object key;

        protected KeyQuery() {
        }

        protected KeyQuery(Object key) {
            this.key = Assert.notNull(key, "key");
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = serializer.readObject(buffer);
        }
    }

    public static abstract class KeyCommand<V>
    extends MultiMapCommand<V> {
        protected Object key;

        protected KeyCommand() {
        }

        protected KeyCommand(Object key) {
            this.key = Assert.notNull(key, "key");
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.key = serializer.readObject(buffer);
        }
    }

    public static abstract class MultiMapQuery<V>
    implements Query<V>,
    CatalystSerializable {
        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static abstract class MultiMapCommand<V>
    implements Command<V>,
    CatalystSerializable {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

