/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.collections.DistributedMultiMap;
import io.atomix.collections.state.MultiMapCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class MultiMapState
extends ResourceStateMachine {
    private final Map<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>> map = new HashMap<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>>();
    private final Map<Long, Scheduled> timers = new HashMap<Long, Scheduled>();
    private DistributedMultiMap.Order order = DistributedMultiMap.Order.INSERT;

    public MultiMapState() {
        super(new ResourceType(DistributedMultiMap.class));
    }

    @Override
    public void configure(Properties config) {
        this.order = DistributedMultiMap.Order.valueOf(config.getProperty("order", DistributedMultiMap.Order.INSERT.name().toLowerCase()).toUpperCase());
        HashSet<Object> keys = new HashSet<Object>(this.map.keySet());
        for (Object e : keys) {
            this.map.put(e, this.createValueMap(this.map.get(e)));
        }
    }

    private Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> createValueMap() {
        switch (this.order) {
            case NONE: {
                return new HashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>();
            }
            case NATURAL: {
                return new TreeMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>();
            }
            case INSERT: {
                return new LinkedHashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>();
            }
        }
        return new HashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>();
    }

    private Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> createValueMap(Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> map) {
        switch (this.order) {
            case NONE: {
                return new HashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>(map);
            }
            case NATURAL: {
                return new TreeMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>(map);
            }
            case INSERT: {
                return new LinkedHashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>(map);
            }
        }
        return new HashMap<Object, Commit<? extends MultiMapCommands.TtlCommand>>(map);
    }

    public boolean containsKey(Commit<MultiMapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.map.containsKey(commit.operation().key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection get(Commit<MultiMapCommands.Get> commit) {
        try {
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(commit.operation().key());
            if (values == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<Object> results = new ArrayList<Object>(values.size());
            for (Commit<? extends MultiMapCommands.TtlCommand> value : values.values()) {
                results.add(value.operation().value());
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        finally {
            commit.close();
        }
    }

    public boolean put(Commit<MultiMapCommands.Put> commit) {
        try {
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(commit.operation().key());
            if (values == null) {
                values = this.createValueMap();
                this.map.put(commit.operation().key(), values);
            }
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> keyValues = values;
            if (!values.containsKey(commit.operation().value())) {
                Scheduled timer = commit.operation().ttl() > 0L ? this.executor.schedule(Duration.ofMillis(commit.operation().ttl()), () -> ((Commit)keyValues.remove(((MultiMapCommands.Put)commit.operation()).value())).close()) : null;
                values.put(commit.operation().value(), commit);
                this.timers.put(commit.index(), timer);
                return true;
            }
            commit.close();
            return false;
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Commit<MultiMapCommands.Remove> commit) {
        try {
            if (commit.operation().value() != null) {
                Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(commit.operation().key());
                if (values == null) {
                    Boolean bl = false;
                    return bl;
                }
                Commit<? extends MultiMapCommands.TtlCommand> previous = values.remove(commit.operation().value());
                if (previous == null) {
                    Boolean bl = false;
                    return bl;
                }
                Scheduled timer = this.timers.remove(previous.index());
                if (timer != null) {
                    timer.cancel();
                }
                previous.close();
                if (values.isEmpty()) {
                    this.map.remove(commit.operation().key());
                }
                Boolean bl = true;
                return bl;
            }
            Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.remove(commit.operation().key());
            if (values != null) {
                ArrayList<Object> results = new ArrayList<Object>(values.size());
                for (Commit<? extends MultiMapCommands.TtlCommand> value : values.values()) {
                    Scheduled timer = this.timers.remove(value.index());
                    if (timer != null) {
                        timer.cancel();
                    }
                    results.add(value.operation().value());
                    value.close();
                }
                ArrayList<Object> arrayList = results;
                return arrayList;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(Commit<MultiMapCommands.RemoveValue> commit) {
        try {
            Iterator<Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>>> outerIterator = this.map.entrySet().iterator();
            while (outerIterator.hasNext()) {
                Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> map = outerIterator.next().getValue();
                Iterator<Map.Entry<Object, Commit<? extends MultiMapCommands.TtlCommand>>> innerIterator = map.entrySet().iterator();
                while (innerIterator.hasNext()) {
                    Map.Entry<Object, Commit<? extends MultiMapCommands.TtlCommand>> entry = innerIterator.next();
                    if ((entry.getValue().operation().value() != null || commit.operation().value() != null) && (entry.getValue().operation().value() == null || commit.operation().value() == null || !entry.getValue().operation().value().equals(commit.operation().value()))) continue;
                    Scheduled timer = this.timers.remove(entry.getValue().index());
                    if (timer != null) {
                        timer.cancel();
                    }
                    entry.getValue().close();
                    innerIterator.remove();
                }
                if (!map.isEmpty()) continue;
                outerIterator.remove();
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Commit<MultiMapCommands.Size> commit) {
        try {
            if (commit.operation().key() != null) {
                Map<Object, Commit<? extends MultiMapCommands.TtlCommand>> values = this.map.get(commit.operation().key());
                int n = values != null ? values.size() : 0;
                return n;
            }
            int size = 0;
            for (Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>> entry : this.map.entrySet()) {
                size += entry.getValue().size();
            }
            int n = size;
            return n;
        }
        finally {
            commit.close();
        }
    }

    public boolean isEmpty(Commit<MultiMapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map == null || this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    public void clear(Commit<MultiMapCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    @Override
    public void delete() {
        Iterator<Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Map<Object, Commit<? extends MultiMapCommands.TtlCommand>>> entry = iterator.next();
            for (Commit<? extends MultiMapCommands.TtlCommand> value : entry.getValue().values()) {
                Scheduled timer = this.timers.remove(value.index());
                if (timer != null) {
                    timer.cancel();
                }
                value.close();
            }
            iterator.remove();
        }
    }
}

