/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;

public class QueueCommands {
    private QueueCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Contains.class, -90);
            registry.register(Add.class, -91);
            registry.register(Offer.class, -92);
            registry.register(Peek.class, -93);
            registry.register(Poll.class, -94);
            registry.register(Element.class, -95);
            registry.register(Remove.class, -96);
            registry.register(IsEmpty.class, -97);
            registry.register(Size.class, -98);
            registry.register(Clear.class, -99);
        }
    }

    public static class Clear
    extends QueueCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class IsEmpty
    extends QueueQuery<Boolean> {
    }

    public static class Size
    extends QueueQuery<Integer> {
    }

    public static class Remove
    extends ValueCommand<Object> {
        public Remove() {
        }

        public Remove(Object value) {
            super(value);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Element
    extends QueueCommand<Object> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Poll
    extends QueueCommand<Object> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Peek
    extends QueueQuery<Object> {
    }

    public static class Offer
    extends ValueCommand<Boolean> {
        public Offer() {
        }

        public Offer(Object value) {
            super(value);
        }
    }

    public static class Add
    extends ValueCommand<Boolean> {
        public Add() {
        }

        public Add(Object value) {
            super(value);
        }
    }

    public static class Contains
    extends ValueQuery<Boolean> {
        public Contains() {
        }

        public Contains(Object value) {
            super(value);
        }
    }

    public static abstract class ValueQuery<V>
    extends QueueQuery<V> {
        protected Object value;

        protected ValueQuery() {
        }

        protected ValueQuery(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static abstract class ValueCommand<V>
    extends QueueCommand<V> {
        protected Object value;

        protected ValueCommand() {
        }

        protected ValueCommand(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class QueueQuery<V>
    implements Query<V>,
    CatalystSerializable {
        private QueueQuery() {
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    private static abstract class QueueCommand<V>
    implements Command<V>,
    CatalystSerializable {
        private QueueCommand() {
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

