/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;

public class SetCommands {
    private SetCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Contains.class, -100);
            registry.register(Add.class, -101);
            registry.register(Remove.class, -102);
            registry.register(IsEmpty.class, -103);
            registry.register(Size.class, -104);
            registry.register(Clear.class, -105);
        }
    }

    public static class Clear
    extends SetCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class IsEmpty
    extends SetQuery<Boolean> {
    }

    public static class Size
    extends SetQuery<Integer> {
    }

    public static class Remove
    extends ValueCommand<Boolean> {
        public Remove() {
        }

        public Remove(Object value) {
            super(value);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Add
    extends TtlCommand<Boolean> {
        public Add() {
        }

        public Add(Object value) {
            super(value, 0L);
        }

        public Add(Object value, long ttl) {
            super(value, ttl);
        }
    }

    public static abstract class TtlCommand<V>
    extends ValueCommand<V> {
        protected long ttl;

        protected TtlCommand() {
        }

        protected TtlCommand(Object value, long ttl) {
            super(value);
            this.ttl = ttl;
        }

        @Override
        public Command.CompactionMode compaction() {
            return this.ttl > 0L ? Command.CompactionMode.SEQUENTIAL : Command.CompactionMode.QUORUM;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.ttl = buffer.readLong();
        }
    }

    public static class Contains
    extends ValueQuery<Boolean> {
        public Contains() {
        }

        public Contains(Object value) {
            super(value);
        }
    }

    private static abstract class ValueQuery<V>
    extends SetQuery<V> {
        protected Object value;

        public ValueQuery() {
        }

        public ValueQuery(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class ValueCommand<V>
    extends SetCommand<V> {
        protected Object value;

        public ValueCommand() {
        }

        public ValueCommand(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class SetQuery<V>
    implements Query<V>,
    CatalystSerializable {
        private SetQuery() {
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    private static abstract class SetCommand<V>
    implements Command<V>,
    CatalystSerializable {
        private SetCommand() {
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

