/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Set;

public final class GroupCommands {
    private GroupCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Join.class, -130);
            registry.register(Leave.class, -131);
            registry.register(Listen.class, -132);
            registry.register(Resign.class, -133);
            registry.register(Schedule.class, -134);
            registry.register(Execute.class, -135);
            registry.register(SetProperty.class, -136);
            registry.register(GetProperty.class, -137);
            registry.register(RemoveProperty.class, -138);
            registry.register(Send.class, -139);
            registry.register(Message.class, -140);
        }
    }

    public static class Message
    implements CatalystSerializable {
        private String member;
        private String topic;
        private Object body;

        public Message() {
        }

        public Message(String member, String topic, Object body) {
            this.member = member;
            this.topic = Assert.notNull(topic, "topic");
            this.body = body;
        }

        public String member() {
            return this.member;
        }

        public String topic() {
            return this.topic;
        }

        public Object body() {
            return this.body;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeString(this.member).writeString(this.topic);
            serializer.writeObject(this.body, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.member = buffer.readString();
            this.topic = buffer.readString();
            this.body = serializer.readObject(buffer);
        }
    }

    public static class Send
    extends MemberCommand<Void> {
        private String topic;
        private Object message;

        public Send() {
        }

        public Send(String member, String topic, Object message) {
            super(member);
            this.topic = Assert.notNull(topic, "topic");
            this.message = message;
        }

        public String topic() {
            return this.topic;
        }

        public Object message() {
            return this.message;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.topic);
            serializer.writeObject(this.message, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.topic = buffer.readString();
            this.message = serializer.readObject(buffer);
        }
    }

    public static class RemoveProperty
    extends PropertyCommand<Void> {
        public RemoveProperty() {
        }

        public RemoveProperty(String member, String property) {
            super(member, property);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class GetProperty
    extends GroupQuery<Object> {
        private String member;
        private String property;

        public GetProperty() {
        }

        public GetProperty(String member, String property) {
            this.member = member;
            this.property = property;
        }

        public String member() {
            return this.member;
        }

        public String property() {
            return this.property;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.member).writeString(this.property);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.member = buffer.readString();
            this.property = buffer.readString();
        }
    }

    public static class SetProperty
    extends PropertyCommand<Void> {
        private Object value;

        public SetProperty() {
        }

        public SetProperty(String member, String property, Object value) {
            super(member, property);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static abstract class PropertyCommand<T>
    extends MemberCommand<T> {
        private String property;

        protected PropertyCommand() {
        }

        protected PropertyCommand(String member, String property) {
            super(member);
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.property);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.property = buffer.readString();
        }
    }

    public static class Resign
    extends MemberCommand<Void> {
        public Resign() {
        }

        public Resign(String member) {
            super(member);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Listen
    extends GroupCommand<Set<String>> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }
    }

    public static class Execute
    extends MemberCommand<Void> {
        private Runnable callback;

        public Execute() {
        }

        public Execute(String member, Runnable callback) {
            super(member);
            this.callback = Assert.notNull(callback, "callback");
        }

        public Runnable callback() {
            return this.callback;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.callback, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.callback = (Runnable)serializer.readObject(buffer);
        }
    }

    public static class Schedule
    extends MemberCommand<Void> {
        private long delay;
        private Runnable callback;

        public Schedule() {
        }

        public Schedule(String member, long delay, Runnable callback) {
            super(member);
            this.delay = Assert.argNot(delay, delay <= 0L, "delay must be positive", new Object[0]);
            this.callback = Assert.notNull(callback, "callback");
        }

        public long delay() {
            return this.delay;
        }

        public Runnable callback() {
            return this.callback;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.callback, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.delay = buffer.readLong();
            this.callback = (Runnable)serializer.readObject(buffer);
        }
    }

    public static abstract class MemberCommand<T>
    extends GroupCommand<T> {
        private String member;

        protected MemberCommand() {
        }

        protected MemberCommand(String member) {
            this.member = member;
        }

        public String member() {
            return this.member;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.member);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.member = buffer.readString();
        }
    }

    public static class Leave
    extends MemberCommand<Void> {
        public Leave() {
        }

        public Leave(String member) {
            super(member);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Join
    extends MemberCommand<String> {
        private boolean persist;

        public Join() {
        }

        public Join(String member, boolean persist) {
            super(member);
            this.persist = persist;
        }

        public boolean persist() {
            return this.persist;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeBoolean(this.persist);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.persist = buffer.readBoolean();
        }
    }

    public static abstract class GroupQuery<V>
    implements Query<V>,
    CatalystSerializable {
        @Override
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.BOUNDED_LINEARIZABLE;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }

    public static abstract class GroupCommand<V>
    implements Command<V>,
    CatalystSerializable {
        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

