/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;

public final class LockCommands {
    private LockCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Lock.class, -141);
            registry.register(Unlock.class, -142);
            registry.register(LockEvent.class, -143);
        }
    }

    public static class LockEvent
    implements CatalystSerializable {
        private int id;
        private long version;

        public LockEvent() {
        }

        public LockEvent(int id, long version) {
            this.id = id;
            this.version = version;
        }

        public int id() {
            return this.id;
        }

        public long version() {
            return this.version;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeInt(this.id).writeLong(this.version);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.id = buffer.readInt();
            this.version = buffer.readLong();
        }

        public String toString() {
            return String.format("%s[id=%d, version=%d]", this.getClass().getSimpleName(), this.id, this.version);
        }
    }

    public static class Unlock
    extends LockCommand<Void> {
        private int id;

        public Unlock() {
        }

        public Unlock(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeInt(this.id);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.id = buffer.readInt();
        }
    }

    public static class Lock
    extends LockCommand<Void> {
        private int id;
        private long timeout;

        public Lock() {
        }

        public Lock(int id, long timeout) {
            this.id = id;
            this.timeout = timeout;
        }

        public int id() {
            return this.id;
        }

        public long timeout() {
            return this.timeout;
        }

        @Override
        public Command.CompactionMode compaction() {
            return this.timeout > 0L ? Command.CompactionMode.SEQUENTIAL : Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeInt(this.id).writeLong(this.timeout);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.id = buffer.readInt();
            this.timeout = buffer.readLong();
        }
    }

    public static abstract class LockCommand<V>
    implements Command<V>,
    CatalystSerializable {
        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

