/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Managed;
import io.atomix.catalyst.util.concurrent.CatalystThreadFactory;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.DefaultCopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.RetryStrategies;
import io.atomix.copycat.client.RetryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.protocol.ClientRequestTypeResolver;
import io.atomix.copycat.protocol.ClientResponseTypeResolver;
import io.atomix.copycat.session.Session;
import io.atomix.copycat.session.SessionTypeResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface CopycatClient
extends Managed<CopycatClient> {
    public static Builder builder(Address ... members) {
        return CopycatClient.builder(Arrays.asList((Object[])Assert.notNull(members, "members")));
    }

    public static Builder builder(Collection<Address> members) {
        return new Builder(members);
    }

    public State state();

    public Listener<State> onStateChange(Consumer<State> var1);

    public ThreadContext context();

    public Transport transport();

    public Serializer serializer();

    public Session session();

    default public <T> CompletableFuture<T> submit(Operation<T> operation) {
        Assert.notNull(operation, "operation");
        if (operation instanceof Command) {
            return this.submit((Command)operation);
        }
        if (operation instanceof Query) {
            return this.submit((Query)operation);
        }
        throw new IllegalArgumentException("unknown operation type");
    }

    public <T> CompletableFuture<T> submit(Command<T> var1);

    public <T> CompletableFuture<T> submit(Query<T> var1);

    public Listener<Void> onEvent(String var1, Runnable var2);

    public <T> Listener<T> onEvent(String var1, Consumer<T> var2);

    @Override
    public CompletableFuture<CopycatClient> open();

    public CompletableFuture<CopycatClient> recover();

    @Override
    public CompletableFuture<Void> close();

    public static final class Builder
    implements io.atomix.catalyst.util.Builder<CopycatClient> {
        private Transport transport;
        private Serializer serializer;
        private CatalystThreadFactory threadFactory;
        private ThreadContext context;
        private Set<Address> members;
        private ConnectionStrategy connectionStrategy = ConnectionStrategies.ONCE;
        private ServerSelectionStrategy serverSelectionStrategy = ServerSelectionStrategies.ANY;
        private RetryStrategy retryStrategy = RetryStrategies.FIBONACCI_BACKOFF;
        private RecoveryStrategy recoveryStrategy = RecoveryStrategies.CLOSE;

        private Builder(Collection<Address> members) {
            this.members = new HashSet<Address>(Assert.notNull(members, "members"));
        }

        public Builder withTransport(Transport transport) {
            this.transport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = Assert.notNull(serializer, "serializer");
            return this;
        }

        public Builder withThreadFactory(CatalystThreadFactory factory) {
            this.threadFactory = Assert.notNull(factory, "factory");
            return this;
        }

        public Builder withThreadContext(ThreadContext context) {
            this.context = Assert.notNull(context, "context");
            return this;
        }

        public Builder withConnectionStrategy(ConnectionStrategy connectionStrategy) {
            this.connectionStrategy = Assert.notNull(connectionStrategy, "connectionStrategy");
            return this;
        }

        public Builder withServerSelectionStrategy(ServerSelectionStrategy serverSelectionStrategy) {
            this.serverSelectionStrategy = Assert.notNull(serverSelectionStrategy, "serverSelectionStrategy");
            return this;
        }

        public Builder withRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = Assert.notNull(retryStrategy, "retryStrategy");
            return this;
        }

        public Builder withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
            this.recoveryStrategy = Assert.notNull(recoveryStrategy, "recoveryStrategy");
            return this;
        }

        @Override
        public CopycatClient build() {
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("io.atomix.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            if (this.threadFactory == null) {
                this.threadFactory = new CatalystThreadFactory("copycat-client-%d");
            }
            if (this.context != null) {
                this.context.serializer().resolve(new ClientRequestTypeResolver());
                this.context.serializer().resolve(new ClientResponseTypeResolver());
                this.context.serializer().resolve(new SessionTypeResolver());
                return new DefaultCopycatClient(this.transport, this.members, this.context, this.threadFactory, this.serverSelectionStrategy, this.connectionStrategy, this.retryStrategy, this.recoveryStrategy);
            }
            if (this.serializer == null) {
                this.serializer = new Serializer();
            }
            this.serializer.resolve(new ClientRequestTypeResolver());
            this.serializer.resolve(new ClientResponseTypeResolver());
            this.serializer.resolve(new SessionTypeResolver());
            return new DefaultCopycatClient(this.transport, this.members, this.serializer, this.threadFactory, this.serverSelectionStrategy, this.connectionStrategy, this.retryStrategy, this.recoveryStrategy);
        }
    }

    public static enum State {
        CONNECTED,
        SUSPENDED,
        CLOSED;

    }
}

